/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingOutputStream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.Histogram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    @NotNull
    public S writePosition(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLimit(long var1) throws BufferOverflowException;

    @NotNull
    public S writeSkip(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public OutputStream outputStream() {
        return new StreamingOutputStream(this);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBit(long x) throws BufferOverflowException {
        BytesInternal.writeStopBit(this, x);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeStopBit(double d) throws BufferOverflowException {
        BytesInternal.writeStopBit(this, d);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUtf8(CharSequence cs) throws BufferOverflowException {
        BytesInternal.writeUtf8(this, cs);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUtf8(String s) throws BufferOverflowException {
        BytesInternal.writeUtf8(this, s);
        return (S)this;
    }

    @Deprecated
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUTF\u0394(CharSequence cs) throws BufferOverflowException {
        return this.writeUtf8(cs);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@Nullable CharSequence cs) throws BufferOverflowException {
        if (cs == null) {
            return this.writeStopBit(-1L);
        }
        if (cs instanceof BytesStore) {
            return this.write8bit((BytesStore)cs);
        }
        if (cs instanceof String) {
            return this.write8bit((String)cs);
        }
        return this.write8bit(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        this.writeStopBit(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + start);
            this.writeUnsignedByte(c);
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException {
        if (cs instanceof BytesStore) {
            return this.write((BytesStore)cs);
        }
        return this.write(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence s, int start, int length) throws BufferOverflowException, IllegalArgumentException, IndexOutOfBoundsException {
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + start);
            this.appendUtf8(c);
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@Nullable @net.openhft.chronicle.core.annotation.NotNull String s) throws BufferOverflowException {
        if (s == null) {
            this.writeStopBit(-1L);
        } else {
            this.write8bit(s, 0, s.length());
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write8bit(@NotNull @net.openhft.chronicle.core.annotation.NotNull BytesStore sdi) throws BufferOverflowException {
        long offset = sdi.readPosition();
        long readRemaining = sdi.readLimit() - offset;
        this.writeStopBit(readRemaining);
        this.write(sdi, offset, readRemaining);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeByte(byte var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedByte(int i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeShort(short var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedShort(int u16) throws BufferOverflowException, IllegalArgumentException {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeInt24(int i) throws BufferOverflowException {
        this.writeUnsignedShort(i);
        return this.writeUnsignedByte(i >> 16);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeInt(int var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeIntAdv(int var1, int var2) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeUnsignedInt(long i) throws BufferOverflowException, IllegalArgumentException {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLong(long var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeLongAdv(long var1, int var3) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeFloat(float var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeDouble(double var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull BytesStore bytes) throws BufferOverflowException {
        if (!1.$assertionsDisabled && bytes == this) {
            throw new AssertionError((Object)"you should not write to yourself !");
        }
        return this.write(bytes, bytes.readPosition(), Math.min(this.writeRemaining(), bytes.readRemaining()));
    }

    public long realCapacity();

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeSome(@NotNull @net.openhft.chronicle.core.annotation.NotNull Bytes bytes) throws BufferOverflowException {
        long length = Math.min(bytes.readRemaining(), this.writeRemaining());
        if (length + this.writePosition() >= 0x100000L) {
            length = Math.min(bytes.readRemaining(), this.realCapacity() - this.writePosition());
        }
        this.write(bytes, bytes.readPosition(), length);
        if (length == bytes.readRemaining()) {
            bytes.clear();
        } else {
            bytes.readSkip(length);
            if (bytes.writePosition() > bytes.realCapacity() / 2L) {
                bytes.compact();
            }
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull BytesStore bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException {
        BytesInternal.writeFully(bytes, offset, length, this);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S write(@NotNull @net.openhft.chronicle.core.annotation.NotNull byte[] bytes) throws BufferOverflowException {
        this.write(bytes, 0, bytes.length);
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S write(byte[] var1, int var2, int var3) throws BufferOverflowException, IllegalArgumentException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeSome(ByteBuffer var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S writeBoolean(boolean flag) throws BufferOverflowException {
        return this.writeByte(flag ? (byte)89 : 0);
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeOrderedInt(int var1) throws BufferOverflowException;

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public S writeOrderedLong(long var1) throws BufferOverflowException;

    public void nativeWrite(long var1, long var3) throws BufferOverflowException;

    default public <E extends Enum<E>> void writeEnum(@NotNull @net.openhft.chronicle.core.annotation.NotNull E e) throws BufferOverflowException {
        this.write8bit(e.name());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence cs) throws BufferOverflowException {
        return this.appendUtf8(cs, 0, cs.length());
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(int codepoint) throws BufferOverflowException {
        BytesInternal.appendUtf8Char(this, codepoint);
        return (S)this;
    }

    @NotNull
    default public S appendUtf8(char[] chars, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        char c;
        int i;
        block3: {
            for (i = 0; i < length; ++i) {
                c = chars[offset + i];
                if (c <= '\u007f') {
                    this.writeByte((byte)c);
                    continue;
                }
                break block3;
            }
            return (S)this;
        }
        while (i < length) {
            c = chars[offset + i];
            BytesInternal.appendUtf8Char(this, c);
            ++i;
        }
        return (S)this;
    }

    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    default public S appendUtf8(@NotNull @net.openhft.chronicle.core.annotation.NotNull CharSequence cs, int offset, int length) throws BufferOverflowException, IllegalArgumentException {
        BytesInternal.appendUtf8(this, cs, offset, length);
        return (S)this;
    }

    default public void copyFrom(@NotNull @net.openhft.chronicle.core.annotation.NotNull InputStream input) throws IOException, BufferOverflowException, IllegalArgumentException {
        BytesInternal.copy(input, this);
    }

    default public void writePositionRemaining(long position, long length) {
        this.writeLimit(position + length);
        this.writePosition(position);
    }

    default public void writeHistogram(@NotNull @net.openhft.chronicle.core.annotation.NotNull Histogram histogram) {
        BytesInternal.writeHistogram(this, histogram);
    }

    default public void writeBigDecimal(@NotNull @net.openhft.chronicle.core.annotation.NotNull BigDecimal bd) {
        this.writeBigInteger(bd.unscaledValue());
        this.writeStopBit(bd.scale());
    }

    default public void writeBigInteger(@NotNull @net.openhft.chronicle.core.annotation.NotNull BigInteger bi) {
        byte[] bytes = bi.toByteArray();
        this.writeStopBit(bytes.length);
        this.write(bytes);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

