/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.annotation.ForceInline;

interface RandomCommon
extends ReferenceCounted {
    @ForceInline
    default public long start() {
        return 0L;
    }

    @ForceInline
    default public long capacity() {
        return Long.MAX_VALUE;
    }

    @ForceInline
    default public long readPosition() {
        return this.start();
    }

    @ForceInline
    default public long writePosition() {
        return this.start();
    }

    @ForceInline
    default public long readRemaining() {
        return this.readLimit() - this.readPosition();
    }

    @ForceInline
    default public long writeRemaining() {
        return this.writeLimit() - this.writePosition();
    }

    @ForceInline
    default public long readLimit() {
        return this.capacity();
    }

    @ForceInline
    default public long writeLimit() {
        return this.capacity();
    }

    public long address(long var1) throws UnsupportedOperationException, IllegalArgumentException;

    default public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    public Bytes bytesForRead() throws IllegalStateException;

    public Bytes bytesForWrite() throws IllegalStateException;

    public boolean compareAndSwapInt(long var1, int var3, int var4) throws BufferOverflowException, IllegalArgumentException;

    public boolean compareAndSwapLong(long var1, long var3, long var5) throws BufferOverflowException, IllegalArgumentException;

    default public boolean compareAndSwapFloat(long offset, float expected, float value) throws BufferOverflowException, IllegalArgumentException {
        return this.compareAndSwapInt(offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(value));
    }

    default public boolean compareAndSwapDouble(long offset, double expected, double value) throws BufferOverflowException, IllegalArgumentException {
        return this.compareAndSwapLong(offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(value));
    }

    public boolean isNative();

    public boolean sharedMemory();
}

