/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public interface RandomDataInput
extends RandomCommon {
    public static final String[] charToString = RandomDataInput.createCharToString();

    @NotNull
    public static String[] createCharToString() {
        int i;
        String[] charToString = new String[256];
        charToString[0] = "\u0660";
        for (i = 1; i < 21; ++i) {
            charToString[i] = Character.toString((char)(i + 9351));
        }
        for (i = 32; i < 256; ++i) {
            charToString[i] = Character.toString((char)i);
        }
        for (i = 21; i < 32; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        for (i = 128; i < 160; ++i) {
            charToString[i] = "\\u00" + Integer.toHexString(i).toUpperCase();
        }
        return charToString;
    }

    @ForceInline
    default public boolean readBoolean(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readByte(offset) != 0;
    }

    public byte readByte(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public int readUnsignedByte(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readByte(offset) & 0xFF;
    }

    public short readShort(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public int readUnsignedShort(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readShort(offset) & 0xFFFF;
    }

    default public int readUnsignedInt24(long offset) throws BufferUnderflowException, IORuntimeException {
        return this.readUnsignedShort(offset) | this.readUnsignedByte(offset) << 16;
    }

    public int readInt(long var1) throws BufferUnderflowException, IORuntimeException;

    @ForceInline
    default public long readUnsignedInt(long offset) throws BufferUnderflowException, IORuntimeException {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1) throws BufferUnderflowException, IORuntimeException;

    public float readFloat(long var1) throws BufferUnderflowException, IORuntimeException;

    public double readDouble(long var1) throws BufferUnderflowException, IORuntimeException;

    default public String printable(long offset) throws BufferUnderflowException, IORuntimeException {
        return charToString[this.readUnsignedByte(offset)];
    }

    default public byte readVolatileByte(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readByte(offset);
    }

    default public short readVolatileShort(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readShort(offset);
    }

    default public int readVolatileInt(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readInt(offset);
    }

    default public float readVolatileFloat(long offset) throws BufferUnderflowException, IORuntimeException {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    default public long readVolatileLong(long offset) throws BufferUnderflowException, IORuntimeException {
        OS.memory().loadFence();
        return this.readLong(offset);
    }

    default public double readVolatileDouble(long offset) throws BufferUnderflowException, IORuntimeException {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    default public long parseLong(long offset) throws BufferUnderflowException, IORuntimeException {
        return BytesInternal.parseLong(this, offset);
    }

    public void nativeRead(long var1, long var3, long var5);

    default public int copyTo(@NotNull byte[] bytes) throws BufferUnderflowException, IORuntimeException {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte(this.start() + (long)i);
        }
        return len;
    }

    default public int copyTo(@NotNull ByteBuffer bb) throws BufferUnderflowException, IORuntimeException {
        int i;
        int len = (int)Math.min((long)bb.remaining(), this.readRemaining());
        for (i = 0; i < len - 7; i += 8) {
            bb.putLong(i, this.readLong(this.start() + (long)i));
        }
        for (i = 0; i < len; ++i) {
            bb.put(i, this.readByte(this.start() + (long)i));
        }
        return len;
    }

    default public long readIncompleteLong(long offset) throws IORuntimeException {
        long left = this.readRemaining() - offset;
        long l = 0L;
        try {
            if (left >= 8L) {
                return this.readLong(offset);
            }
            if (left == 4L) {
                return this.readInt(offset);
            }
            l = 0L;
            int remaining = (int)left;
            for (int i = 0; i < remaining; ++i) {
                l |= (long)this.readUnsignedByte(offset + (long)i) << i * 8;
            }
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        return l;
    }

    public long realCapacity();

    default public int addAndGetInt(long offset, int adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetInt(this, offset, adding);
    }

    default public long addAndGetLong(long offset, long adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetLong(this, offset, adding);
    }

    default public float addAndGetFloat(long offset, float adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetFloat(this, offset, adding);
    }

    default public double addAndGetDouble(long offset, double adding) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.addAndGetDouble(this, offset, adding);
    }

    default public BytesStore subBytes(long start, long length) {
        return BytesInternal.subBytes(this, start, length);
    }

    default public int findByte(byte stopByte) {
        return BytesInternal.findByte(this, stopByte);
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8(long offset, @NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int len = Maths.toUInt31((long)utfLen);
        BytesInternal.parseUtf8(this, offset, sb, len);
        return offset + utfLen;
    }

    default public <ACS extends Appendable & CharSequence> long readUtf8Limited(long offset, @NotNull ACS sb, int maxUtf8Len) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException {
        AppendableUtil.setLength(sb, 0);
        long utfLen = this.readByte(offset++);
        if (utfLen < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)this.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return offset ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (utfLen > (long)maxUtf8Len) {
            throw new IllegalStateException("Attempted to read a char sequence of utf8 size " + utfLen + ", when only " + maxUtf8Len + " allowed");
        }
        BytesInternal.parseUtf8(this, offset, sb, (int)utfLen);
        return offset + utfLen;
    }

    @Nullable
    default public String readUtf8Limited(long offset, int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, IllegalStateException {
        return BytesInternal.readUtf8(this, offset, maxUtf8Len);
    }

    default public boolean compareUtf8(long offset, @Nullable CharSequence other) {
        return BytesInternal.compareUtf8(this, offset, other);
    }

    default public byte[] toByteArray() throws IORuntimeException, IllegalArgumentException {
        return BytesInternal.toByteArray(this);
    }

    default public long read(long offsetInRDI, byte[] bytes, int offset, int length) {
        int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = this.readByte(offsetInRDI + (long)i);
        }
        return len;
    }

    default public ByteBuffer toTemporaryDirectByteBuffer() {
        int len = Maths.toUInt31((long)this.readRemaining());
        ByteBuffer bb = ByteBuffer.allocateDirect(len);
        this.copyTo(bb);
        bb.clear();
        return bb;
    }

    default public int fastHash(long offset, int length) {
        int i;
        long hash = 0L;
        for (i = 0; i < length - 3; i += 4) {
            hash += (long)this.readInt(offset + (long)i);
            hash *= 1829709757L;
        }
        if (i < length - 1) {
            hash += (long)this.readShort(offset + (long)i);
            hash *= 1829709757L;
            i += 2;
        }
        if (i < length) {
            hash += (long)this.readByte(offset + (long)i);
        }
        return (int)(hash ^ hash >> 32);
    }
}

