/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.util.Compressions;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public interface Compression {
    public static <T> void compress(CharSequence cs, Bytes uncompressed, Bytes compressed) {
        switch (cs.charAt(0)) {
            case 'l': {
                if (!StringUtils.isEqual((CharSequence)"lzw", (CharSequence)cs)) break;
                Compressions.LZW.compress(uncompressed, compressed);
                return;
            }
            case 's': {
                if (!StringUtils.isEqual((CharSequence)"snappy", (CharSequence)cs)) break;
                Compressions.Snappy.compress(uncompressed, compressed);
                return;
            }
            case 'g': {
                if (!StringUtils.isEqual((CharSequence)"gzip", (CharSequence)cs)) break;
                Compressions.GZIP.compress(uncompressed, compressed);
                return;
            }
        }
        Compressions.Binary.compress(uncompressed, compressed);
    }

    public static void uncompress(CharSequence cs, Bytes from, Bytes to) {
        switch (cs.charAt(0)) {
            case '!': 
            case 'b': {
                if (!StringUtils.isEqual((CharSequence)"binary", (CharSequence)cs) && !StringUtils.isEqual((CharSequence)"!binary", (CharSequence)cs)) break;
                Compressions.Binary.uncompress(from, to);
                return;
            }
            case 'l': {
                if (!StringUtils.isEqual((CharSequence)"lzw", (CharSequence)cs)) break;
                Compressions.LZW.uncompress(from, to);
                return;
            }
            case 's': {
                if (!StringUtils.isEqual((CharSequence)"snappy", (CharSequence)cs)) break;
                Compressions.Snappy.uncompress(from, to);
                return;
            }
            case 'g': {
                if (!StringUtils.isEqual((CharSequence)"gzip", (CharSequence)cs)) break;
                Compressions.GZIP.uncompress(from, to);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported compression " + cs);
    }

    @Nullable
    public static <T> byte[] uncompress(CharSequence cs, T t, Function<T, byte[]> bytes) {
        switch (cs.charAt(0)) {
            case '!': 
            case 'b': {
                if (!StringUtils.isEqual((CharSequence)"binary", (CharSequence)cs) && !StringUtils.isEqual((CharSequence)"!binary", (CharSequence)cs)) break;
                return Compressions.Binary.uncompress(bytes.apply(t));
            }
            case 'l': {
                if (!StringUtils.isEqual((CharSequence)"lzw", (CharSequence)cs)) break;
                return Compressions.LZW.uncompress(bytes.apply(t));
            }
            case 's': {
                if (!StringUtils.isEqual((CharSequence)"snappy", (CharSequence)cs)) break;
                return Compressions.Snappy.uncompress(bytes.apply(t));
            }
            case 'g': {
                if (!StringUtils.isEqual((CharSequence)"gzip", (CharSequence)cs)) break;
                return Compressions.GZIP.uncompress(bytes.apply(t));
            }
        }
        return null;
    }

    default public byte[] compress(byte[] bytes) throws IORuntimeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream output = this.compressingStream(baos);){
            output.write(bytes);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return baos.toByteArray();
    }

    default public void compress(Bytes from, Bytes to) throws IORuntimeException {
        try (OutputStream output = this.compressingStream(to.outputStream());){
            from.copyTo(output);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    default public byte[] uncompress(byte[] bytes) throws IORuntimeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream input = this.decompressingStream(new ByteArrayInputStream(bytes));){
            int len;
            byte[] buf = new byte[512];
            while ((len = input.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return baos.toByteArray();
    }

    default public void uncompress(Bytes from, Bytes to) {
        try (InputStream input = this.decompressingStream(from.inputStream());){
            to.copyFrom(input);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public InputStream decompressingStream(InputStream var1);

    public OutputStream compressingStream(OutputStream var1);
}

