/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes<Underlying>
implements Bytes<Underlying> {
    @Nullable
    protected BytesStore<Bytes<Underlying>, Underlying> bytesStore;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;
    protected boolean isPresent;
    private int lastDecimalPlaces = 0;

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit) throws IllegalStateException {
        this.bytesStore = bytesStore;
        bytesStore.reserve();
        this.readPosition = bytesStore.readPosition();
        this.writePosition = writePosition;
        this.writeLimit = writeLimit;
    }

    @Override
    public void move(long from, long to, long length) {
        long start = this.start();
        this.bytesStore.move(from - start, to - start, length);
    }

    @Override
    public Bytes<Underlying> compact() {
        long start = this.start();
        long readRemaining = this.readRemaining();
        if (readRemaining > 0L && start < this.readPosition) {
            this.bytesStore.move(this.readPosition, start, readRemaining);
            this.readPosition = start;
            this.writePosition = this.readPosition + readRemaining;
        }
        return this;
    }

    @Override
    public void isPresent(boolean isPresent) {
        this.clear();
        this.isPresent = isPresent;
    }

    @Override
    public boolean isPresent() {
        return this.isPresent;
    }

    @Override
    @NotNull
    public Bytes<Underlying> clear() {
        this.readPosition = this.writePosition = this.start();
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public Bytes<Underlying> clearAndPad(long length) throws BufferOverflowException {
        if (this.start() + length > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.readPosition = this.writePosition = this.start() + length;
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @ForceInline
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @Nullable
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    @ForceInline
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    @ForceInline
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @ForceInline
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readPosition(long position) throws BufferUnderflowException {
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (position > this.readLimit()) {
            throw new BufferUnderflowException();
        }
        this.readPosition = position;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readLimit(long limit) throws BufferUnderflowException {
        if (limit < this.start()) {
            throw new BufferUnderflowException();
        }
        if (limit > this.writeLimit()) {
            throw new BufferUnderflowException();
        }
        this.writePosition = limit;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writePosition(long position) throws BufferOverflowException {
        if (position > this.writeLimit()) {
            throw new BufferOverflowException();
        }
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (position < this.readPosition()) {
            this.readPosition = position;
        }
        this.writePosition = position;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readSkip(long bytesToSkip) throws BufferUnderflowException, IORuntimeException {
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeSkip(long bytesToSkip) throws BufferOverflowException, IORuntimeException {
        this.writeCheckOffset(this.writePosition, bytesToSkip);
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeLimit(long limit) throws BufferOverflowException {
        if (limit < this.start()) {
            throw new BufferOverflowException();
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            assert (false) : "cant set limit=" + limit + " > " + "capacity=" + capacity;
            throw new BufferOverflowException();
        }
        this.writeLimit = limit;
        return this;
    }

    void performRelease() {
        try {
            this.bytesStore.release();
        }
        finally {
            this.bytesStore = NoBytesStore.noBytesStore();
        }
    }

    @Override
    public int readUnsignedByte() throws IORuntimeException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readUnsignedByte(offset);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    @ForceInline
    public byte readByte() throws IORuntimeException {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferUnderflowException e) {
            return 0;
        }
    }

    @Override
    @ForceInline
    public int peekUnsignedByte() throws IORuntimeException {
        try {
            return this.readRemaining() > 0L ? this.bytesStore.readUnsignedByte(this.readPosition) : -1;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    @ForceInline
    public short readShort() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    public int readVolatileInt() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    @ForceInline
    public long readVolatileLong() throws BufferUnderflowException, IORuntimeException {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    protected long readOffsetPositionMoved(long adding) throws BufferUnderflowException, IORuntimeException {
        long offset = this.readPosition;
        this.readCheckOffset(this.readPosition, adding, false);
        this.readPosition += adding;
        assert (this.readPosition <= this.readLimit());
        return offset;
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(long offset, byte i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(long offset, short i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(long offset, int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(long offset, int i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long offset, long i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long offset, long i) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(long offset, float d) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(long offset, double d) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    public Bytes<Underlying> writeVolatileByte(long offset, byte i8) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    public Bytes<Underlying> writeVolatileShort(long offset, short i16) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    public Bytes<Underlying> writeVolatileInt(long offset, int i32) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    public Bytes<Underlying> writeVolatileLong(long offset, long i64) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(long offsetInRDO, RandomDataInput bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException, IllegalArgumentException, IORuntimeException {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @ForceInline
    void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        assert (this.writeCheckOffset0(offset, adding));
    }

    private boolean writeCheckOffset0(long offset, long adding) throws BufferOverflowException {
        if (offset < this.start()) {
            throw new BufferOverflowException();
        }
        if (offset + adding > this.writeLimit()) {
            assert (offset + adding <= this.writeLimit()) : "cant add bytes past the limit : limit=" + this.writeLimit() + ",offset=" + offset + ",adding=" + adding;
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    public byte readByte(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 1L, true);
        return this.bytesStore.readByte(offset);
    }

    @Override
    @ForceInline
    public short readShort(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 2L, true);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 4L, true);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble(long offset) throws BufferUnderflowException, IORuntimeException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readDouble(offset);
    }

    @ForceInline
    void readCheckOffset(long offset, long adding, boolean given) throws BufferUnderflowException, IORuntimeException {
        assert (this.readCheckOffset0(offset, adding, given));
    }

    @ForceInline
    private boolean readCheckOffset0(long offset, long adding, boolean given) throws BufferUnderflowException {
        long limit0;
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        long l = limit0 = given ? this.writeLimit() : this.readLimit();
        if (offset + adding > limit0) {
            throw new BufferUnderflowException();
        }
        return true;
    }

    @ForceInline
    void prewriteCheckOffset(long offset, long subtracting) throws BufferUnderflowException, IORuntimeException {
        assert (this.prewriteCheckOffset0(offset, subtracting));
    }

    @ForceInline
    private boolean prewriteCheckOffset0(long offset, long subtracting) throws BufferOverflowException {
        if (offset - subtracting < this.start()) {
            throw new BufferOverflowException();
        }
        long limit0 = this.readLimit();
        if (offset > limit0) {
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeByte(byte i8) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    public Bytes<Underlying> prewrite(byte[] bytes) {
        long offset = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    public Bytes<Underlying> prewrite(BytesStore bytes) {
        long offset = this.prewriteOffsetPositionMoved(bytes.readRemaining());
        this.bytesStore.write(offset, bytes);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> prewriteByte(byte i8) throws BufferOverflowException, IORuntimeException {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    public Bytes<Underlying> prewriteInt(int i) {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    public Bytes<Underlying> prewriteShort(short i) {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    public Bytes<Underlying> prewriteLong(long l) {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, l);
        return this;
    }

    protected long writeOffsetPositionMoved(long adding) throws BufferOverflowException, IORuntimeException {
        long oldPosition = this.writePosition;
        this.writeCheckOffset(this.writePosition, adding);
        this.writePosition += adding;
        return oldPosition;
    }

    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException, IORuntimeException {
        this.prewriteCheckOffset(this.readPosition, subtracting);
        return this.readPosition -= subtracting;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeShort(short i16) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeInt(int i) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeLong(long i64) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeFloat(float f) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeDouble(double d) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IORuntimeException {
        if ((long)length > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeSome(@NotNull ByteBuffer buffer) throws BufferOverflowException, IORuntimeException {
        int length = (int)Math.min((long)buffer.remaining(), this.writeRemaining());
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), length);
        this.writePosition += (long)length;
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedInt(int i) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public Bytes<Underlying> writeOrderedLong(long i) throws BufferOverflowException, IORuntimeException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long address(long offset) throws BufferOverflowException, BufferUnderflowException {
        return this.bytesStore.address(offset);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        Bytes b2 = (Bytes)obj;
        long remaining = this.readRemaining();
        try {
            return b2.readRemaining() == remaining && this.equalsBytes(b2, remaining);
        }
        catch (IORuntimeException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equalsBytes(@NotNull Bytes b2, long remaining) throws IORuntimeException {
        long i;
        for (i = 0L; i < remaining - 7L; ++i) {
            if (this.readLong(this.readPosition() + i) == b2.readLong(b2.readPosition() + i)) continue;
            return false;
        }
        while (i < remaining) {
            if (this.readByte(this.readPosition() + i) != b2.readByte(b2.readPosition() + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    @ForceInline
    public void nativeRead(long address, long size) throws BufferUnderflowException, IORuntimeException {
        long position = this.readPosition();
        this.readSkip(size);
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long size) throws BufferOverflowException, IORuntimeException {
        long position = this.writePosition();
        this.writeSkip(size);
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }
}

