/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import org.jetbrains.annotations.NotNull;

public class UTF8StringInterner {
    private static final StringBuilderPool SBP = new StringBuilderPool();
    @NotNull
    protected final String[] interner;
    protected final int mask;
    protected final int shift;
    protected boolean toggle = false;

    public UTF8StringInterner(int capacity) throws IllegalArgumentException {
        int n = Maths.nextPower2((int)capacity, (int)128);
        this.shift = Maths.intLog2((long)n);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    public String intern(@NotNull Bytes cs) throws IllegalArgumentException, UTFDataFormatRuntimeException, BufferUnderflowException {
        if (cs.readRemaining() > (long)this.interner.length) {
            return this.getString(cs);
        }
        int hash = BytesStoreHash.hash32(cs);
        int h = hash & this.mask;
        String s = this.interner[h];
        if (cs.isEqual(s)) {
            return s;
        }
        int h2 = hash >> this.shift & this.mask;
        String s2 = this.interner[h2];
        if (cs.isEqual(s)) {
            return s2;
        }
        String str = this.getString(cs);
        String string = str;
        this.interner[s == null || s2 != null && this.toggle() ? h : h2] = string;
        return string;
    }

    @NotNull
    private String getString(@NotNull Bytes cs) {
        StringBuilder sb = SBP.acquireStringBuilder();
        long pos = cs.readPosition();
        cs.parseUtf8(sb, Maths.toInt32((long)cs.readRemaining()));
        cs.readPosition(pos);
        return sb.toString();
    }

    protected boolean toggle() {
        this.toggle = !this.toggle;
        return this.toggle;
    }

    public int valueCount() {
        return (int)Stream.of(this.interner).filter(s -> s != null).count();
    }
}

