/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;

public class TextLongArrayReference
implements ByteableLongArrayValues {
    private static final byte[] SECTION1 = "{ capacity: ".getBytes();
    private static final byte[] SECTION2 = ", values: [ ".getBytes();
    private static final byte[] SECTION3 = " ] }\n".getBytes();
    private static final byte[] ZERO = "00000000000000000000".getBytes();
    private static final byte[] SEP = ", ".getBytes();
    private static final int DIGITS = ZERO.length;
    private static final int CAPACITY = SECTION1.length;
    private static final int VALUES = CAPACITY + DIGITS + SECTION2.length;
    private static final int VALUE_SIZE = DIGITS + SEP.length;
    private BytesStore bytes;
    private long offset;
    private long length = VALUES;

    public static void write(@NotNull Bytes bytes, long capacity) {
        bytes.write(SECTION1);
        bytes.append(bytes.writePosition(), capacity, 20);
        bytes.writeSkip(20L);
        bytes.write(SECTION2);
        for (long i = 0L; i < capacity; ++i) {
            if (i > 0L) {
                bytes.appendUtf8(", ");
            }
            bytes.write(ZERO);
        }
        bytes.write(SECTION3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) {
        return bytes.parseLong(offset + (long)CAPACITY) * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }

    public long getCapacity() {
        return (this.length - (long)VALUES) / (long)VALUE_SIZE;
    }

    public long getValueAt(long index) {
        return this.bytes.parseLong((long)VALUES + this.offset + index * (long)VALUE_SIZE);
    }

    public void setValueAt(long index, long value) {
        this.bytes.append((long)VALUES + this.offset + index * (long)VALUE_SIZE, value, DIGITS);
    }

    public void bindValueAt(int index, LongValue value) {
        throw new UnsupportedOperationException("todo");
    }

    public long getVolatileValueAt(long index) {
        OS.memory().loadFence();
        return this.getValueAt(index);
    }

    public void setOrderedValueAt(long index, long value) {
        this.setValueAt(index, value);
        OS.memory().storeFence();
    }

    public boolean compareAndSet(long index, long expected, long value) {
        throw new UnsupportedOperationException("todo");
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        if (length != TextLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + TextLongArrayReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "LongArrayTextReference{bytes=null, offset=" + this.offset + ", length=" + this.length + '}';
        }
        return "value: " + this.getValueAt(0L) + " ...";
    }

    @Override
    public long sizeInBytes(long capacity) {
        return capacity * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }
}

