/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.StringUtils;

final class BytesInternal
extends Enum<BytesInternal> {
    static final char[] HEXI_DECIMAL;
    private static final byte[] MIN_VALUE_TEXT;
    private static final StringBuilderPool SBP;
    private static final StringInterner SI;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final ThreadLocal<byte[]> NUMBER_BUFFER;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final ThreadLocal<DateCache> dateCacheTL;
    private static final /* synthetic */ BytesInternal[] $VALUES;

    public static BytesInternal[] values() {
        return (BytesInternal[])$VALUES.clone();
    }

    public static BytesInternal valueOf(String name) {
        return Enum.valueOf(BytesInternal.class, name);
    }

    public static boolean contentEqual(@Nullable BytesStore a, @Nullable BytesStore b) throws IORuntimeException {
        long i;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.readRemaining() != b.readRemaining()) {
            return false;
        }
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        long length = a.readRemaining();
        for (i = 0L; i < length - 7L; i += 8L) {
            if (a.readLong(aPos + i) == b.readLong(bPos + i)) continue;
            return false;
        }
        while (i < length) {
            if (a.readByte(aPos + i) != b.readByte(bPos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void parseUTF(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesInternal.parseUTF_SB1((Bytes)bytes, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parseUTF1(bytes, appendable, utflen);
        }
    }

    public static void parseUTF(@NotNull RandomDataInput input, long offset, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        if (appendable instanceof StringBuilder) {
            if (input instanceof NativeBytesStore) {
                BytesInternal.parseUTF_SB1((NativeBytesStore)input, offset, (StringBuilder)appendable, utflen);
                return;
            }
            if (input instanceof Bytes && ((Bytes)input).bytesStore() instanceof NativeBytesStore) {
                NativeBytesStore bs = (NativeBytesStore)((Bytes)input).bytesStore();
                BytesInternal.parseUTF_SB1(bs, offset, (StringBuilder)appendable, utflen);
                return;
            }
        }
        BytesInternal.parseUTF1(input, offset, appendable, utflen);
    }

    public static boolean compareUTF(RandomDataInput input, long offset, CharSequence other) {
        long utfLen;
        if ((utfLen = (long)input.readByte(offset++)) < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)input.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return BytesInternal.compareUTF(input, offset, utfLen, other);
    }

    private static boolean compareUTF(RandomDataInput input, long offset, long utfLen, CharSequence other) {
        byte c;
        int i;
        if (offset + utfLen > input.realCapacity()) {
            throw new BufferUnderflowException();
        }
        for (i = 0; (long)i < utfLen && i < other.length() && (c = input.readByte(offset + (long)i)) >= 0; ++i) {
            if ((char)c == other.charAt(i)) continue;
            return false;
        }
        if ((long)i < utfLen && i < other.length()) {
            return BytesInternal.compareUTF2(input, offset + (long)i, i, utfLen, other);
        }
        return utfLen == (long)other.length();
    }

    private static boolean compareUTF2(RandomDataInput input, long offset, int charI, long utfLen, CharSequence other) throws UTFDataFormatRuntimeException {
        long limit = offset + utfLen;
        while (offset < limit && charI < other.length()) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if ((char)c == other.charAt(charI)) break;
                    return false;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen) + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if ((char)c2 == other.charAt(charI)) break;
                    return false;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen - 1L) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if ((char)c3 == other.charAt(charI)) break;
                    return false;
                }
                default: {
                    throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen));
                }
            }
            ++charI;
        }
        return offset == limit && charI == other.length();
    }

    public static void parse8bit(long offset, @NotNull RandomDataInput bytesStore, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        if (bytesStore instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesInternal.parse8bit_SB1(offset, (NativeBytesStore)bytesStore, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parse8bit1(offset, bytesStore, appendable, utflen);
        }
    }

    public static void parseUTF1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            int count;
            assert (bytes.readRemaining() >= (long)utflen);
            for (count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                if (c >= 128) {
                    bytes.readSkip(-1L);
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (utflen > count) {
                BytesInternal.parseUTF2(bytes, appendable, utflen, count);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parseUTF1(@NotNull RandomDataInput input, long offset, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            assert (input.realCapacity() >= offset + (long)utflen);
            long limit = offset + (long)utflen;
            while (offset < limit) {
                int c;
                if ((c = input.readUnsignedByte(offset++)) >= 128) {
                    --offset;
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (limit > offset) {
                BytesInternal.parseUTF2(input, offset, limit, appendable, utflen);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        try {
            assert (bytes.readRemaining() >= (long)utflen);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                appendable.append((char)c);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse8bit1(long offset, @NotNull RandomDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            assert (bytes.readRemaining() >= (long)utflen);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte(offset + (long)count);
                appendable.append((char)c);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parseUTF_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            byte c;
            int count = 0;
            if ((long)utflen > bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
            long address = nbs.address + nbs.translate(bytes.readPosition());
            Memory memory = nbs.memory;
            sb.ensureCapacity(utflen);
            char[] chars = StringUtils.extractChars((StringBuilder)sb);
            while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                chars[count++] = (char)c;
            }
            bytes.readSkip(count);
            StringUtils.setCount((StringBuilder)sb, (int)count);
            if (count < utflen) {
                BytesInternal.parseUTF2(bytes, sb, utflen, count);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parseUTF_SB1(@NotNull NativeBytesStore bytes, long offset, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            byte c;
            if (offset + (long)utflen > bytes.realCapacity()) {
                throw new BufferUnderflowException();
            }
            long address = bytes.address + bytes.translate(offset);
            Memory memory = bytes.memory;
            sb.ensureCapacity(utflen);
            char[] chars = StringUtils.extractChars((StringBuilder)sb);
            int count = 0;
            while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                chars[count++] = (char)c;
            }
            StringUtils.setCount((StringBuilder)sb, (int)count);
            if (count < utflen) {
                BytesInternal.parseUTF2(bytes, offset + (long)count, offset + (long)utflen, sb, utflen);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int parse8bit_SB1(long offset, NativeBytesStore nbs, @NotNull StringBuilder sb, int utflen) {
        long address = nbs.address + nbs.translate(offset);
        Memory memory = nbs.memory;
        sb.ensureCapacity(utflen);
        char[] chars = StringUtils.extractChars((StringBuilder)sb);
        int count = 0;
        while (count < utflen) {
            int c = memory.readByte(address + (long)count) & 0xFF;
            chars[count++] = (char)c;
        }
        StringUtils.setCount((StringBuilder)sb, (int)count);
        return count;
    }

    static void parseUTF2(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen, int count) throws IOException {
        block5: while (count < utflen) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + count + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (count - 1) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + count);
        }
    }

    static void parseUTF2(@NotNull RandomDataInput input, long offset, long limit, @NotNull Appendable appendable, int utflen) throws IOException, UTFDataFormatRuntimeException {
        block5: while (offset < limit) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen) + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen - 1L) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen));
        }
    }

    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable String str) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        char[] chars = StringUtils.extractChars((String)str);
        long utfLength = BytesInternal.findUTFLength(chars);
        bytes.writeStopBit(utfLength);
        bytes.appendUtf8(chars, 0, chars.length);
    }

    @ForceInline
    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable CharSequence str) throws BufferOverflowException, IllegalArgumentException, IORuntimeException, IndexOutOfBoundsException {
        if (str instanceof String) {
            BytesInternal.writeUtf8(bytes, (String)str);
            return;
        }
        if (str == null) {
            bytes.writeStopBit(-1L);
        } else {
            long utfLength = BytesInternal.findUTFLength(str);
            bytes.writeStopBit(utfLength);
            BytesInternal.appendUTF(bytes, str, 0, str.length());
        }
    }

    @ForceInline
    public static long writeUtf8(@NotNull RandomDataOutput out, long offset, @Nullable CharSequence str) throws BufferOverflowException, IllegalArgumentException, IORuntimeException, IndexOutOfBoundsException {
        if (str == null) {
            offset = BytesInternal.writeStopBit(out, offset, -1L);
        } else {
            int strLength = str.length();
            if (strLength < 32) {
                long lenOffset = offset;
                offset = BytesInternal.appendUTF(out, offset + 1L, str, 0, strLength);
                long utfLength = offset - lenOffset - 1L;
                assert (utfLength <= 127L);
                BytesInternal.writeStopBit(out, lenOffset, utfLength);
            } else {
                long utfLength = BytesInternal.findUTFLength(str);
                offset = BytesInternal.writeStopBit(out, offset, utfLength);
                if (utfLength == (long)strLength) {
                    BytesInternal.append8bit(offset, out, str, 0, strLength);
                    offset += utfLength;
                } else {
                    offset = BytesInternal.appendUTF(out, offset, str, 0, strLength);
                }
            }
        }
        return offset;
    }

    @ForceInline
    public static long writeUtf8(@NotNull RandomDataOutput out, long offset, @Nullable CharSequence str, int maxUtf8Len) throws BufferOverflowException, IllegalArgumentException, IORuntimeException, IndexOutOfBoundsException {
        if (str == null) {
            offset = BytesInternal.writeStopBit(out, offset, -1L);
        } else {
            int strLength = str.length();
            long utfLength = BytesInternal.findUTFLength(str);
            if (utfLength > (long)maxUtf8Len) {
                throw new IllegalArgumentException("Attempted to write a char sequence of utf8 size " + utfLength + ": \"" + str + "\", when only " + maxUtf8Len + " allowed");
            }
            offset = BytesInternal.writeStopBit(out, offset, utfLength);
            if (utfLength == (long)strLength) {
                BytesInternal.append8bit(offset, out, str, 0, strLength);
                offset += utfLength;
            } else {
                offset = BytesInternal.appendUTF(out, offset, str, 0, strLength);
            }
        }
        return offset;
    }

    static long findUTFLength(@NotNull CharSequence str) throws IndexOutOfBoundsException {
        int strlen = str.length();
        long utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    private static long findUTFLength(@NotNull char[] chars) {
        int strlen = chars.length;
        long utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = chars[i];
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    @NotNull
    public static Bytes asBytes(@NotNull RandomDataOutput bytes, long position, long limit) throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        Bytes sbytes = bytes.bytesForWrite();
        sbytes.writeLimit(limit);
        sbytes.readLimit(limit);
        sbytes.readPosition(position);
        return sbytes;
    }

    public static void appendUTF(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length) throws IndexOutOfBoundsException, IORuntimeException, BufferOverflowException {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(offset + i)) <= '\u007f'; ++i) {
            bytes.writeByte((byte)c);
        }
        BytesInternal.appendUTF2(bytes, str, offset, length, i);
    }

    private static void appendUTF2(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length, int i) throws IndexOutOfBoundsException, IORuntimeException, BufferOverflowException {
        while (i < length) {
            char c = str.charAt(offset + i);
            BytesInternal.appendUTFChar(bytes, c);
            ++i;
        }
    }

    public static long appendUTF(@NotNull RandomDataOutput out, long outOffset, @NotNull CharSequence str, int strOffset, int length) throws IndexOutOfBoundsException, IORuntimeException, BufferOverflowException {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(strOffset + i)) <= '\u007f'; ++i) {
            out.writeByte(outOffset++, (byte)c);
        }
        return BytesInternal.appendUTF2(out, outOffset, str, strOffset, length, i);
    }

    private static long appendUTF2(@NotNull RandomDataOutput out, long outOffset, @NotNull CharSequence str, int strOffset, int length, int i) throws IndexOutOfBoundsException, IORuntimeException, BufferOverflowException {
        while (i < length) {
            char c = str.charAt(strOffset + i);
            outOffset = BytesInternal.appendUTFChar(out, outOffset, c);
            ++i;
        }
        return outOffset;
    }

    public static void append8bit(long offsetInRDO, RandomDataOutput bytes, @NotNull CharSequence str, int offset, int length) throws IllegalArgumentException, BufferOverflowException, IORuntimeException, BufferUnderflowException, IndexOutOfBoundsException {
        if (bytes instanceof VanillaBytes) {
            VanillaBytes vb = (VanillaBytes)bytes;
            if (str instanceof RandomDataInput) {
                vb.write(offsetInRDO, (RandomDataInput)((Object)str), (long)offset, (long)length);
                return;
            }
            if (str instanceof String) {
                vb.write(offsetInRDO, str, offset, length);
                return;
            }
        }
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(offset + i);
            if (c > 255) {
                c = 63;
            }
            bytes.writeUnsignedByte(offsetInRDO + (long)i, c);
        }
    }

    public static void appendUTFChar(@NotNull StreamingDataOutput bytes, int c) throws IORuntimeException, BufferOverflowException {
        if (c <= 127) {
            bytes.writeByte((byte)c);
        } else if (c <= 2047) {
            bytes.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            bytes.writeByte((byte)(0xE0 | c >> 12 & 0xF));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        } else {
            bytes.writeByte((byte)(0xF0 | c >> 18 & 7));
            bytes.writeByte((byte)(0x80 | c >> 12 & 0x3F));
            bytes.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static long appendUTFChar(@NotNull RandomDataOutput out, long offset, int c) throws IORuntimeException, BufferOverflowException {
        if (c <= 127) {
            out.writeByte(offset++, (byte)c);
        } else if (c <= 2047) {
            out.writeByte(offset++, (byte)(0xC0 | c >> 6 & 0x1F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            out.writeByte(offset++, (byte)(0xE0 | c >> 12 & 0xF));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else {
            out.writeByte(offset++, (byte)(0xF0 | c >> 18 & 7));
            out.writeByte(offset++, (byte)(0x80 | c >> 12 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        }
        return offset;
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) throws IORuntimeException, BufferOverflowException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte((byte)(n & 0x7FL));
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte((byte)(n & 0x7FL | 0x80L));
            out.writeByte((byte)(n >> 7));
            return;
        }
        BytesInternal.writeStopBit0(out, n);
    }

    public static long writeStopBit(@NotNull RandomDataOutput out, long offset, long n) throws IORuntimeException, BufferOverflowException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte(offset++, (byte)(n & 0x7FL));
            return offset;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte(offset++, (byte)(n & 0x7FL | 0x80L));
            out.writeByte(offset++, (byte)(n >> 7));
            return offset;
        }
        return BytesInternal.writeStopBit0(out, offset, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, double d) throws IORuntimeException, BufferOverflowException {
        long n = Double.doubleToRawLongBits(d);
        while ((n & 0x1FFFFFFFFFFFFFFL) != 0L) {
            out.writeByte((byte)(n >>> -7 & 0x7FL | 0x80L));
            n <<= 7;
        }
        out.writeByte((byte)(n >>> -7 & 0x7FL));
    }

    public static double readStopBitDouble(@NotNull StreamingDataInput in) throws IORuntimeException {
        byte b;
        long n = 0L;
        int shift = 57;
        do {
            b = in.readByte();
            n |= shift > 0 ? (long)(b & 0x7F) << shift : (long)(b >> -shift);
            shift -= 7;
        } while (b < 0);
        return Double.longBitsToDouble(n);
    }

    static void writeStopBit0(@NotNull StreamingDataOutput out, long n) throws IORuntimeException, BufferOverflowException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte((byte)n);
        } else {
            out.writeByte((byte)(0x80L | n));
            out.writeByte((byte)0);
        }
    }

    static long writeStopBit0(@NotNull RandomDataOutput out, long offset, long n) throws IORuntimeException, BufferOverflowException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte(offset++, (byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte(offset++, (byte)n);
        } else {
            out.writeByte(offset++, (byte)(0x80L | n));
            out.writeByte(offset++, (byte)0);
        }
        return offset;
    }

    static int stopBitLength0(long n) {
        int len = 0;
        if (n < 0L) {
            len = 1;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n >>>= 7) != 0L) {
            ++len;
        }
        return len + 1;
    }

    public static String toDebugString(@NotNull RandomDataInput bytes, long maxLength) {
        StringBuilder sb = new StringBuilder(200);
        long position = bytes.readPosition();
        sb.append("[").append("pos: ").append(position).append(", rlim: ").append(bytes.readLimit()).append(", wlim: ").append(BytesInternal.asSize(bytes.writeLimit())).append(", cap: ").append(BytesInternal.asSize(bytes.capacity())).append(" ] ");
        try {
            BytesInternal.toString(bytes, sb, position - maxLength, position, position + maxLength);
        }
        catch (Exception e) {
            sb.append(' ').append(e);
        }
        return sb.toString();
    }

    @NotNull
    public static Object asSize(long size) {
        return size == Long.MAX_VALUE ? "8EiB" : Long.valueOf(size);
    }

    public static String to8bitString(@NotNull BytesStore bytes) throws IllegalArgumentException, IORuntimeException {
        long pos = bytes.readPosition();
        int len = Maths.toInt32((long)bytes.readRemaining());
        char[] chars = new char[len];
        if (bytes instanceof VanillaBytes) {
            ((VanillaBytes)bytes).read8Bit(chars, len);
        } else {
            for (int i = 0; i < len; ++i) {
                try {
                    chars[i] = (char)bytes.readUnsignedByte(pos + (long)i);
                    continue;
                }
                catch (Exception e) {
                    return new String(chars, 0, len) + ' ' + e;
                }
            }
        }
        return StringUtils.newString((char[])chars);
    }

    public static String toString(@NotNull RandomDataInput bytes) throws IllegalStateException, IORuntimeException {
        int size = 1024;
        StringBuilder sb = new StringBuilder(1024);
        if (bytes.readRemaining() > 1024L) {
            Bytes bytes1 = bytes.bytesForRead();
            bytes1.readLimit(bytes1.readPosition() + 1024L);
            BytesInternal.toString(bytes1, sb);
            return sb.toString() + "...";
        }
        BytesInternal.toString(bytes, sb);
        return sb.toString();
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, long start, long position, long end) throws BufferUnderflowException {
        try {
            if (start < 0L) {
                start = 0L;
            }
            if (position > start) {
                long last = Math.min(position, bytes.readLimit());
                for (long i = start; i < last; ++i) {
                    sb.append(bytes.printable(i));
                }
                sb.append('\u2016');
                if (position >= bytes.readLimit()) {
                    return;
                }
            }
            if (end > bytes.readLimit()) {
                end = bytes.readLimit();
            }
            for (long i = position; i < end; ++i) {
                sb.append(bytes.printable(i));
            }
        }
        catch (IOException e) {
            try {
                sb.append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull StringBuilder sb) throws IllegalStateException, IORuntimeException {
        bytes.reserve();
        assert (bytes.start() <= bytes.readPosition());
        assert (bytes.readPosition() <= bytes.readLimit());
        assert (bytes.readLimit() <= bytes.realCapacity());
        try {
            for (long i = bytes.readPosition(); i < bytes.readLimit(); ++i) {
                sb.append((char)bytes.readUnsignedByte(i));
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(' ').append(e);
        }
        bytes.release();
    }

    @ForceInline
    public static long readStopBit(@NotNull StreamingDataInput in) throws IORuntimeException {
        long l = in.readByte();
        if (l >= 0L) {
            return l;
        }
        return BytesInternal.readStopBit0(in, l);
    }

    static long readStopBit0(@NotNull StreamingDataInput in, long l) throws IORuntimeException {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)in.readByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void append(@NotNull ByteStringAppender out, long num) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.write(MIN_VALUE_TEXT);
                return;
            }
            out.writeByte((byte)45);
            num = -num;
        }
        if (num == 0L) {
            out.writeByte((byte)48);
        } else {
            BytesInternal.appendLong0(out, num);
        }
    }

    public static void prepend(@NotNull BytesPrepender out, long num) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        boolean neg = false;
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.prewrite(MIN_VALUE_TEXT);
                return;
            }
            neg = true;
            num = -num;
        }
        do {
            out.prewriteByte((byte)(num % 10L + 48L));
        } while ((num /= 10L) > 0L);
        if (neg) {
            out.prewriteByte((byte)45);
        }
    }

    public static void append(@NotNull RandomDataOutput out, long offset, long num, int digits) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        boolean negative = num < 0L;
        num = Math.abs(num);
        for (int i = digits - 1; i > 0; --i) {
            out.writeByte(offset + (long)i, (byte)(num % 10L + 48L));
            num /= 10L;
        }
        if (negative) {
            if (num != 0L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, 45);
        } else {
            if (num > 9L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)(num % 10L + 48L));
        }
    }

    private static void numberTooLarge(int digits) throws IllegalArgumentException {
        throw new IllegalArgumentException("Number too large for " + digits + "digits");
    }

    private static void appendLong0(@NotNull StreamingDataOutput out, long num) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        byte[] numberBuffer = NUMBER_BUFFER.get();
        int endIndex = BytesInternal.appendLong1(numberBuffer, num);
        out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
    }

    private static int appendLong1(byte[] numberBuffer, long num) {
        numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    public static void append(@NotNull StreamingDataOutput out, double d) throws IORuntimeException, BufferOverflowException, IllegalArgumentException {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            out.writeByte((byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            out.writeByte((byte)48);
            out.writeByte((byte)46);
            out.writeByte((byte)48);
            return;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                out.write(Infinity);
            } else {
                out.write(NaN);
            }
            return;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                BytesInternal.appendLong0(out, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    out.writeByte((byte)46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        out.writeByte((byte)(48L + num));
                        double parsedValue = BytesInternal.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                } else {
                    out.writeByte((byte)46);
                    out.writeByte((byte)48);
                }
                return;
            }
            out.writeByte((byte)48);
            out.writeByte((byte)46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    out.writeByte((byte)48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                out.writeByte((byte)c);
                mantissa -= num << precision;
                double parsedValue = BytesInternal.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        BytesInternal.appendLong0(out, val2);
        for (int i = 0; i < digits; ++i) {
            out.writeByte((byte)48);
        }
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    @ForceInline
    @Nullable
    public static String readUtf8(@NotNull StreamingDataInput in) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8(sb) ? SI.intern((CharSequence)sb) : null;
    }

    @ForceInline
    @Nullable
    public static String readUtf8(@NotNull RandomDataInput in, long offset, int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, IllegalStateException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8Limited(offset, sb, maxUtf8Len) > 0L ? SI.intern((CharSequence)sb) : null;
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    @ForceInline
    @Nullable
    public static String read8bit(@NotNull StreamingDataInput in) throws BufferUnderflowException, IORuntimeException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.read8bit(sb) ? SI.intern((CharSequence)sb) : null;
    }

    @ForceInline
    @NotNull
    public static String parseUTF(@NotNull StreamingDataInput bytes, @NotNull StopCharTester tester) {
        StringBuilder utfReader = BytesInternal.acquireStringBuilder();
        BytesInternal.parseUTF(bytes, (Appendable)utfReader, tester);
        return SI.intern((CharSequence)utfReader);
    }

    @ForceInline
    public static void parseUTF(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharTester tester) throws BufferUnderflowException, IllegalStateException {
        try {
            if (builder instanceof StringBuilder && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore) {
                Bytes vb = (Bytes)bytes;
                StringBuilder sb = (StringBuilder)builder;
                sb.setLength(0);
                BytesInternal.readUTF_SB1(vb, sb, tester);
            } else {
                AppendableUtil.setLength(builder, 0);
                BytesInternal.readUTF1(bytes, builder, tester);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    private static void readUTF_SB1(@NotNull Bytes bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IOException, IllegalArgumentException, IllegalStateException, BufferUnderflowException {
        byte c;
        int i;
        NativeBytesStore nb = (NativeBytesStore)bytes.bytesStore();
        int len = Maths.toInt32((long)bytes.readRemaining());
        long address = nb.address + nb.translate(bytes.readPosition());
        Memory memory = nb.memory;
        for (i = 0; i < len && (c = memory.readByte(address + (long)i)) >= 0; ++i) {
            if (tester.isStopChar(c)) {
                bytes.readSkip(i + 1);
                return;
            }
            appendable.append((char)c);
        }
        bytes.readSkip(i);
        if (i < len) {
            BytesInternal.readUTF_SB2(bytes, appendable, tester);
        }
    }

    private static void readUTF_SB2(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws UTFDataFormatException, IORuntimeException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    private static void readUTF1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException, IllegalArgumentException, BufferUnderflowException {
        int len = Maths.toInt32((long)bytes.readRemaining());
        while (len-- > 0) {
            int c = bytes.readUnsignedByte();
            if (c >= 128) {
                bytes.readSkip(-1L);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        if (len <= 0) {
            return;
        }
        BytesInternal.readUTF2(bytes, appendable, tester);
    }

    private static void readUTF2(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    @ForceInline
    public static void parseUTF(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharsTester tester) throws IllegalArgumentException, BufferUnderflowException, IORuntimeException {
        AppendableUtil.setLength(builder, 0);
        try {
            AppendableUtil.readUTFAndAppend(bytes, builder, tester);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharsTester tester) throws IORuntimeException {
        builder.setLength(0);
        AppendableUtil.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharsTester tester) throws BufferUnderflowException, BufferOverflowException, IllegalArgumentException, IORuntimeException {
        builder.readPosition(0L);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharTester tester) throws IORuntimeException {
        builder.setLength(0);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharTester tester) throws BufferUnderflowException, BufferOverflowException, IllegalArgumentException, IORuntimeException {
        builder.readPosition(0L);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IORuntimeException {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharTester tester) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch)) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next = bytes.readUnsignedByte();
        } while (bytes.readRemaining() > 1L);
        if (tester.isStopChar(ch)) {
            bytes.readSkip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharsTester tester) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        int ch = bytes.readUnsignedByte();
        do {
            int next;
            if (tester.isStopChar(ch, next = bytes.readUnsignedByte())) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
            ch = next;
        } while (bytes.readRemaining() > 1L);
        if (tester.isStopChar(ch, -1)) {
            bytes.readSkip(-1L);
            return;
        }
        bytes2.writeUnsignedByte(ch);
    }

    public static double parseDouble(@NotNull StreamingDataInput in) throws IORuntimeException, BufferUnderflowException {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        int ch = in.readUnsignedByte();
        switch (ch) {
            case 78: {
                if (BytesInternal.compareRest(in, "aN")) {
                    return Double.NaN;
                }
                in.readSkip(-1L);
                return Double.NaN;
            }
            case 73: {
                if (BytesInternal.compareRest(in, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                in.readSkip(-1L);
                return Double.NaN;
            }
            case 45: {
                if (BytesInternal.compareRest(in, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = in.readUnsignedByte();
            }
        }
        while (true) {
            if (ch >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != 46) break;
                decimalPlaces = 0;
            }
            if (in.readRemaining() == 0L) break;
            ch = in.readUnsignedByte();
        }
        return BytesInternal.asDouble(value, exp, negative, decimalPlaces);
    }

    static boolean compareRest(@NotNull StreamingDataInput in, @NotNull String s) throws IORuntimeException, BufferUnderflowException {
        if ((long)s.length() > in.readRemaining()) {
            return false;
        }
        long position = in.readPosition();
        for (int i = 0; i < s.length(); ++i) {
            if (in.readUnsignedByte() == s.charAt(i)) continue;
            in.readPosition(position);
            return false;
        }
        return true;
    }

    @ForceInline
    public static long parseLong(@NotNull StreamingDataInput in) throws IORuntimeException, BufferUnderflowException {
        long num = 0L;
        boolean negative = false;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 95) continue;
        }
        return negative ? -num : num;
    }

    public static long parseLong(@NotNull RandomDataInput in, long offset) throws IORuntimeException, BufferUnderflowException {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = in.readUnsignedByte(offset++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b != 95) break;
        }
        return negative ? -num : num;
    }

    public static boolean skipTo(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) throws IORuntimeException {
        while (parser.readRemaining() > 0L) {
            int ch = parser.readUnsignedByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    public static float addAndGetFloat(@NotNull RandomDataInput in, long offset, float adding) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        float value1;
        int value2;
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = Float.floatToRawIntBits(value1 = Float.intBitsToFloat(value) + adding))) {
        }
        return value1;
    }

    public static double addAndGetDouble(@NotNull RandomDataInput in, long offset, double adding) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        double value1;
        long value2;
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = Double.doubleToRawLongBits(value1 = Double.longBitsToDouble(value) + adding))) {
        }
        return value1;
    }

    public static int addAndGetInt(@NotNull RandomDataInput in, long offset, int adding) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        int value2;
        int value;
        while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = value + adding)) {
        }
        return value2;
    }

    public static long addAndGetLong(@NotNull RandomDataInput in, long offset, long adding) throws IORuntimeException, BufferUnderflowException, IllegalArgumentException, BufferOverflowException {
        long value2;
        long value;
        while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = value + adding)) {
        }
        return value2;
    }

    public static String toHexString(@NotNull Bytes bytes) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.toHexString(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(@NotNull Bytes bytes, long offset, long len) throws BufferUnderflowException, IORuntimeException {
        if (len == 0L) {
            return "";
        }
        int width = 16;
        int[] lastLine = new int[width];
        String sep = "";
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readLimit(offset + len);
            bytes.readPosition(offset);
            StringBuilder builder = new StringBuilder();
            long start = offset / (long)width * (long)width;
            long end = (offset + len + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                if (i + (long)width < end) {
                    boolean same = true;
                    for (j = 0; j < width && i + (long)j < offset + len; ++j) {
                        ch = bytes.readUnsignedByte(i + (long)j);
                        same &= ch == lastLine[j];
                        lastLine[j] = ch;
                    }
                    if (i > start && same) {
                        sep = "........\n";
                        continue;
                    }
                }
                builder.append(sep);
                sep = "";
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXI_DECIMAL[ch >> 4]);
                    builder.append(HEXI_DECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < start || i + (long)j >= offset + len) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    public static void appendTimeMillis(@NotNull ByteStringAppender b, long timeInMS) throws IORuntimeException, BufferOverflowException, IllegalArgumentException {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            b.append(hours);
        } else {
            b.writeByte((byte)(hours / 10 + 48));
            b.writeByte((byte)(hours % 10 + 48));
        }
        b.writeByte((byte)58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        b.writeByte((byte)(minutes / 10 + 48));
        b.writeByte((byte)(minutes % 10 + 48));
        b.writeByte((byte)58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        b.writeByte((byte)(seconds / 10 + 48));
        b.writeByte((byte)(seconds % 10 + 48));
        b.writeByte((byte)46);
        int millis = (int)(timeInMS % 1000L);
        b.writeByte((byte)(millis / 100 + 48));
        b.writeByte((byte)(millis / 10 % 10 + 48));
        b.writeByte((byte)(millis % 10 + 48));
    }

    public static boolean equalBytesAny(@NotNull BytesStore b1, @NotNull BytesStore b2, long remaining) throws IORuntimeException, BufferUnderflowException {
        int i2;
        long i;
        BytesStore bs1 = b1.bytesStore();
        BytesStore bs2 = b2.bytesStore();
        for (i = 0L; i < remaining - 7L; ++i) {
            long l2;
            long l1 = bs1.readLong(b1.readPosition() + i);
            if (l1 == (l2 = bs2.readLong(b2.readPosition() + i))) continue;
            return false;
        }
        if (i < remaining - 3L) {
            int i1 = bs1.readInt(b1.readPosition() + i);
            if (i1 != (i2 = bs2.readInt(b2.readPosition() + i))) {
                return false;
            }
            i += 4L;
        }
        while (i < remaining) {
            byte i1 = bs1.readByte(b1.readPosition() + i);
            if (i1 != (i2 = (int)bs2.readByte(b2.readPosition() + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendDateMillis(@NotNull ByteStringAppender b, long timeInMS) throws IORuntimeException, BufferOverflowException {
        DateCache dateCache = dateCacheTL.get();
        if (dateCache == null) {
            dateCache = new DateCache();
            dateCacheTL.set(dateCache);
        }
        long date = timeInMS / 86400000L;
        if (dateCache.lastDay != date) {
            DateCache.access$102(dateCache, dateCache.dateFormat.format(new Date(timeInMS)).getBytes(StandardCharsets.ISO_8859_1));
            dateCache.lastDay = date;
        } else assert (dateCache.lastDateStr != null);
        b.write(dateCache.lastDateStr);
    }

    public static <E extends Enum<E>, S extends StreamingDataInput<S>> E readEnum(StreamingDataInput input, Class<E> eClass) throws BufferUnderflowException, IORuntimeException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        input.read8bit(sb);
        return (E)((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern((CharSequence)sb);
    }

    public static void write(@NotNull BytesStore bytes, long offset, long length, StreamingDataOutput sdo) throws IORuntimeException, BufferUnderflowException, BufferOverflowException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            sdo.writeLong(bytes.readLong(offset + i));
        }
        if (i < length - 3L) {
            sdo.writeInt(bytes.readInt(offset + i));
            i += 4L;
        }
        while (i < length) {
            sdo.writeByte(bytes.readByte(offset + i));
            ++i;
        }
    }

    public static byte[] toByteArray(RandomDataInput in) throws IllegalArgumentException, IORuntimeException {
        int len = Maths.toInt32((long)in.readRemaining());
        byte[] bytes = new byte[len];
        in.read(in.readPosition(), bytes);
        return bytes;
    }

    public static void copy(RandomDataInput input, OutputStream output) throws IOException {
        int len;
        byte[] bytes = new byte[512];
        long start = input.readPosition();
        int i = 0;
        while ((len = (int)input.read(start + (long)i, bytes)) > 0) {
            output.write(bytes, 0, len);
            i += len;
        }
    }

    public static void copy(InputStream input, StreamingDataOutput output) throws IOException, IllegalArgumentException, BufferOverflowException {
        int len;
        byte[] bytes = new byte[512];
        while ((len = input.read(bytes)) > 0) {
            output.write(bytes, 0, len);
        }
    }

    public static Boolean parseBoolean(ByteStringParser parser, StopCharTester tester) {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        BytesInternal.parseUTF((StreamingDataInput)parser, (Appendable)sb, tester);
        if (sb.length() == 0) {
            return null;
        }
        switch (sb.charAt(0)) {
            case 'T': 
            case 't': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)"true") ? Boolean.valueOf(true) : null;
            }
            case 'Y': 
            case 'y': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)"yes") ? Boolean.valueOf(true) : null;
            }
            case '0': {
                return sb.length() == 1 ? Boolean.valueOf(false) : null;
            }
            case '1': {
                return sb.length() == 1 ? Boolean.valueOf(true) : null;
            }
            case 'F': 
            case 'f': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)"false") ? Boolean.valueOf(false) : null;
            }
            case 'N': 
            case 'n': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)"no") ? Boolean.valueOf(false) : null;
            }
        }
        return null;
    }

    public static BytesStore subBytes(RandomDataInput from, long start, long length) {
        NativeBytesStore<Void> ret = NativeBytesStore.nativeStore(length);
        ret.write(0L, from, start, length);
        return ret;
    }

    public static int findByte(RandomDataInput bytes, byte stopByte) {
        long start = bytes.readPosition();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (bytes.readByte(start + (long)i) != stopByte) continue;
            return i;
        }
        throw new IllegalArgumentException("Stop byte " + stopByte + " not found");
    }

    static {
        $VALUES = new BytesInternal[0];
        HEXI_DECIMAL = "0123456789ABCDEF".toCharArray();
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
        SBP = new StringBuilderPool();
        SI = new StringInterner(1024);
        Infinity = "Infinity".getBytes();
        NaN = "NaN".getBytes();
        NUMBER_BUFFER = ThreadLocal.withInitial(() -> new byte[20]);
        dateCacheTL = new ThreadLocal();
        try {
            ClassAliasPool.CLASS_ALIASES.addAlias(BytesStore.class, "!binary");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static class DateCache {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        private long lastDay = Long.MIN_VALUE;
        @Nullable
        private byte[] lastDateStr = null;

        DateCache() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        static /* synthetic */ byte[] access$102(DateCache x0, byte[] x1) {
            x0.lastDateStr = x1;
            return x1;
        }
    }
}

