/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringWriter;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) throws BufferOverflowException, IOException {
        try {
            BytesInternal.appendUTFChar(this, ch);
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) throws BufferOverflowException, IOException {
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(long value) throws BufferOverflowException, IORuntimeException {
        BytesInternal.append(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(float f) throws BufferOverflowException, IORuntimeException {
        BytesInternal.append((StreamingDataOutput)this, f);
        return (B)this;
    }

    @NotNull
    default public B append(double d) throws BufferOverflowException, IORuntimeException {
        BytesInternal.append((StreamingDataOutput)this, d);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, int start, int end) throws IndexOutOfBoundsException, BufferOverflowException, IOException {
        try {
            BytesInternal.appendUTF(this, cs, start, end - start);
        }
        catch (IORuntimeException e) {
            throw new IOException(e);
        }
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs));
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)start, (long)end));
        }
        for (int i = start; i < end; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B appendDateMillis(long dateInMillis) {
        BytesInternal.appendDateMillis(this, dateInMillis);
        return (B)this;
    }

    default public B appendTimeMillis(long timeOfDayInMillis) {
        BytesInternal.appendTimeMillis(this, timeOfDayInMillis % 86400000L);
        return (B)this;
    }
}

