/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Reader;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringReader;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

interface ByteStringParser<B extends ByteStringParser<B>>
extends StreamingDataInput<B> {
    default public Reader reader() {
        return new ByteStringReader(this);
    }

    default public Boolean parseBoolean(@NotNull StopCharTester tester) {
        return BytesInternal.parseBoolean(this, tester);
    }

    @ForceInline
    @NotNull
    default public String parseUTF(@NotNull StopCharTester stopCharTester) {
        return BytesInternal.parseUTF(this, stopCharTester);
    }

    @ForceInline
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) {
        BytesInternal.parseUTF((StreamingDataInput)this, buffer, stopCharTester);
    }

    @ForceInline
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, IORuntimeException {
        BytesInternal.parseUTF((StreamingDataInput)this, buffer, stopCharsTester);
    }

    @ForceInline
    default public void parse8bit(Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, BufferOverflowException, IORuntimeException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharTester);
        }
    }

    @ForceInline
    default public void parse8bit(Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, IORuntimeException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharsTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharsTester);
        }
    }

    @ForceInline
    default public long parseLong() throws BufferUnderflowException, IORuntimeException {
        return BytesInternal.parseLong(this);
    }

    @ForceInline
    default public double parseDouble() throws BufferUnderflowException, IORuntimeException {
        return BytesInternal.parseDouble(this);
    }

    @ForceInline
    default public boolean skipTo(@NotNull StopCharTester tester) throws IORuntimeException {
        return BytesInternal.skipTo(this, tester);
    }
}

