/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.StringUtils;

public class StringInternerBytes
extends StringInterner {
    private static final StringBuilderPool SBP = new StringBuilderPool();

    public StringInternerBytes(int capacity) {
        super(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bytesToSting(Bytes bytes, byte stopByte) {
        long limit = bytes.readLimit();
        try {
            int h = StringInternerBytes.hash(bytes, bytes.readPosition(), bytes.readLimit(), stopByte) & this.mask;
            String s = this.interner[h];
            if (StringUtils.isEqual((CharSequence)s, (CharSequence)bytes)) {
                String string = s;
                return string;
            }
            char[] chars = new char[(int)bytes.readRemaining()];
            int i = 0;
            while ((long)i < bytes.readRemaining()) {
                chars[i] = (char)bytes.readUnsignedByte((long)i + bytes.readPosition());
                ++i;
            }
            String string = this.interner[h] = StringUtils.newString((char[])chars);
            return string;
        }
        finally {
            bytes.readPosition(bytes.readLimit());
            bytes.readLimit(limit);
        }
    }

    private static int hash(Bytes cs, long position, long limit, byte delimitor) {
        long h = StringInternerBytes.longHash(cs, position, limit, delimitor);
        return (int)(h ^ h >> 32);
    }

    private static long longHash(Bytes cs, long position, long limit, byte delimitor) {
        long hash = 0L;
        for (long i = position; i < limit; ++i) {
            byte b = cs.readByte(i);
            if (b == delimitor) {
                cs.readLimit(i);
                break;
            }
            hash = Long.rotateLeft(hash, 7) + (long)b;
        }
        return Maths.longHash((long)hash);
    }
}

