/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Maths;

public interface RandomDataOutput<R extends RandomDataOutput<R>>
extends RandomCommon {
    default public R writeByte(long offset, int i) {
        return this.writeByte(offset, Maths.toInt8((long)i));
    }

    default public R writeUnsignedByte(long offset, int i) {
        return this.writeByte(offset, (byte)Maths.toUInt8((long)i));
    }

    default public R writeBoolean(long offset, boolean flag) {
        return this.writeByte(offset, flag ? 89 : 0);
    }

    default public R writeUnsignedShort(long offset, int i) {
        return this.writeShort(offset, (short)Maths.toUInt16((long)i));
    }

    default public R writeUnsignedInt(long offset, long i) {
        return this.writeInt(offset, (int)Maths.toUInt32((long)i));
    }

    public R writeByte(long var1, byte var3);

    public R writeShort(long var1, short var3);

    public R writeInt(long var1, int var3);

    public R writeOrderedInt(long var1, int var3);

    public R writeLong(long var1, long var3);

    public R writeOrderedLong(long var1, long var3);

    public R writeFloat(long var1, float var3);

    public R writeDouble(long var1, double var3);

    default public R write(long offsetInRDO, byte[] bytes) {
        return this.write(offsetInRDO, bytes, 0, bytes.length);
    }

    public R write(long var1, byte[] var3, int var4, int var5);

    public void write(long var1, ByteBuffer var3, int var4, int var5);

    default public R write(long offsetInRDO, Bytes bytes) {
        return this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
    }

    public R write(long var1, RandomDataInput var3, long var4, long var6);

    public R zeroOut(long var1, long var3);

    default public R append(long offset, long value, int digits) {
        BytesUtil.append(this, offset, value, digits);
        return (R)this;
    }

    public void nativeWrite(long var1, long var3, long var5);
}

