/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.WriteAccess;
import net.openhft.chronicle.core.Maths;

public interface StreamingDataOutput<S extends StreamingDataOutput<S, A, AT>, A extends WriteAccess<AT>, AT>
extends StreamingCommon<S, A, AT> {
    default public ObjectOutput objectStream() {
        throw new UnsupportedOperationException();
    }

    default public OutputStream outputStream() {
        throw new UnsupportedOperationException();
    }

    default public S writeStopBit(long x) {
        BytesUtil.writeStopBit(this, x);
        return (S)this;
    }

    default public S writeUTF\u0394(CharSequence cs) {
        BytesUtil.writeUTF(this, cs);
        return (S)this;
    }

    public S writeByte(byte var1);

    default public S writeUnsignedByte(int i) {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    public S writeShort(short var1);

    default public S writeUnsignedShort(int u16) {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    public S writeInt(int var1);

    default public S writeUnsignedInt(long i) {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    public S writeLong(long var1);

    public S writeFloat(float var1);

    public S writeDouble(double var1);

    public S write(BytesStore var1);

    public S write(Bytes var1);

    public S write(BytesStore var1, long var2, long var4);

    public S write(Bytes var1, long var2, long var4);

    default public S write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    public S write(byte[] var1, int var2, int var3);

    public S write(ByteBuffer var1);

    default public <T> S write(ReadAccess<T> access, T handle, long offset, long len) {
        long targetOffset = this.accessPositionOffset();
        this.skip(len);
        Access.copy(access, handle, offset, this.access(), this.accessHandle(), targetOffset, len);
        return (S)this;
    }

    default public <T, H> S write(Accessor<T, H, ? extends ReadAccess<H>> accessor, T source, long offset, long len) {
        return this.write(accessor.access(source), accessor.handle(source), accessor.offset(source, offset), accessor.size(len));
    }

    default public S writeBoolean(boolean flag) {
        return this.writeByte(flag ? (byte)89 : 0);
    }

    public S writeOrderedInt(int var1);

    public S writeOrderedLong(long var1);

    @Override
    public A access();

    public void nativeWrite(long var1, long var3);
}

