/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomCommon;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.core.OS;

public interface RandomDataInput<S extends RandomDataInput<S, A, AT>, A extends ReadAccess<AT>, AT>
extends RandomCommon<S, A, AT> {
    default public boolean readBoolean(long offset) {
        return this.readByte(offset) != 0;
    }

    public byte readByte(long var1);

    default public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    public short readShort(long var1);

    default public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    public int readInt(long var1);

    default public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    public long readLong(long var1);

    public float readFloat(long var1);

    public double readDouble(long var1);

    default public char printable(long offset) {
        int b = this.readUnsignedByte(offset);
        if (b == 0) {
            return '\u0660';
        }
        if (b < 21) {
            return (char)(b + 9351);
        }
        return (char)b;
    }

    default public int readVolatileInt(long offset) {
        OS.memory().loadFence();
        return this.readInt(offset);
    }

    default public long readVolatileLong(long offset) {
        OS.memory().loadFence();
        return this.readLong(offset);
    }

    default public long parseLong(long offset) {
        return BytesUtil.parseLong(this, offset);
    }

    @Override
    public A access();

    public void nativeRead(long var1, long var3, long var5);
}

