/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.NativeAccess;
import net.openhft.chronicle.bytes.ReadAccess;

final class PrimitiveAccessors {
    static final long BOOLEAN_VALUE_OFFSET;
    static final long BYTE_VALUE_OFFSET;
    static final long CHARACTER_VALUE_OFFSET;
    static final long SHORT_VALUE_OFFSET;
    static final long INTEGER_VALUE_OFFSET;
    static final long LONG_VALUE_OFFSET;
    static final long FLOAT_VALUE_OFFSET;
    static final long DOUBLE_VALUE_OFFSET;

    private PrimitiveAccessors() {
    }

    static {
        try {
            BOOLEAN_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Boolean.class.getDeclaredField("value"));
            BYTE_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Byte.class.getDeclaredField("value"));
            CHARACTER_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Character.class.getDeclaredField("value"));
            SHORT_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Short.class.getDeclaredField("value"));
            INTEGER_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Integer.class.getDeclaredField("value"));
            LONG_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Long.class.getDeclaredField("value"));
            FLOAT_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Float.class.getDeclaredField("value"));
            DOUBLE_VALUE_OFFSET = NativeAccess.U.objectFieldOffset(Double.class.getDeclaredField("value"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    static enum DoubleAccessor implements Size8PrimitiveAccessor<Double>
    {
        INSTANCE;


        @Override
        public long offset(Double source, long index) {
            return DOUBLE_VALUE_OFFSET + index;
        }
    }

    static enum FloatAccessor implements Size4PrimitiveAccessor<Float>
    {
        INSTANCE;


        @Override
        public long offset(Float source, long index) {
            return FLOAT_VALUE_OFFSET + index;
        }
    }

    static enum LongAccessor implements Size8PrimitiveAccessor<Long>
    {
        INSTANCE;


        @Override
        public long offset(Long source, long index) {
            return LONG_VALUE_OFFSET + index;
        }
    }

    static enum IntegerAccessor implements Size4PrimitiveAccessor<Integer>
    {
        INSTANCE;


        @Override
        public long offset(Integer source, long index) {
            return INTEGER_VALUE_OFFSET + index;
        }
    }

    static enum ShortAccessor implements Size2PrimitiveAccessor<Short>
    {
        INSTANCE;


        @Override
        public long offset(Short source, long index) {
            return SHORT_VALUE_OFFSET + index;
        }
    }

    static enum CharacterAccessor implements Size2PrimitiveAccessor<Character>
    {
        INSTANCE;


        @Override
        public long offset(Character source, long index) {
            return CHARACTER_VALUE_OFFSET + index;
        }
    }

    static enum ByteAccessor implements Size1PrimitiveAccessor<Byte>
    {
        INSTANCE;


        @Override
        public long offset(Byte source, long index) {
            return BYTE_VALUE_OFFSET + index;
        }
    }

    static enum BooleanAccessor implements Size1PrimitiveAccessor<Boolean>
    {
        INSTANCE;


        @Override
        public long offset(Boolean source, long index) {
            return BOOLEAN_VALUE_OFFSET + index;
        }
    }

    static interface Size8PrimitiveAccessor<P>
    extends PrimitiveAccessor<P> {
        @Override
        default public long size(long size) {
            if (!1.$assertionsDisabled && size != 8L) {
                throw new AssertionError();
            }
            return 8L;
        }
    }

    static interface Size4PrimitiveAccessor<P>
    extends PrimitiveAccessor<P> {
        @Override
        default public long size(long size) {
            if (!1.$assertionsDisabled && size != 4L) {
                throw new AssertionError();
            }
            return 4L;
        }
    }

    static interface Size2PrimitiveAccessor<P>
    extends PrimitiveAccessor<P> {
        @Override
        default public long size(long size) {
            if (!1.$assertionsDisabled && size != 2L) {
                throw new AssertionError();
            }
            return 2L;
        }
    }

    static interface Size1PrimitiveAccessor<P>
    extends PrimitiveAccessor<P> {
        @Override
        default public long size(long size) {
            if (!1.$assertionsDisabled && size != 1L) {
                throw new AssertionError();
            }
            return 1L;
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    static interface PrimitiveAccessor<P>
    extends Accessor.Read<P, P> {
        @Override
        default public ReadAccess<P> access(P source) {
            return Access.nativeAccess();
        }

        @Override
        default public P handle(P source) {
            return source;
        }
    }
}

