/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.ReferenceCounter;

public class MappedFile
implements ReferenceCounted {
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel fileChannel;
    private final long chunkSize;
    private final long overlapSize;
    private final List<WeakReference<MappedBytesStore>> stores = new ArrayList<WeakReference<MappedBytesStore>>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ThreadLocal<WeakReference<Bytes>> threadLocalBytes = new ThreadLocal();
    private final long capacity;

    MappedFile(File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.fileChannel = this.raf.getChannel();
        this.chunkSize = OS.mapAlign((long)chunkSize);
        this.overlapSize = overlapSize == 0L ? 0L : OS.mapAlign((long)overlapSize);
        this.capacity = 0x10000000000L;
    }

    public static MappedFile mappedFile(File file, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(file, chunkSize, (long)OS.pageSize());
    }

    public static MappedFile mappedFile(String filename, long chunkSize) throws FileNotFoundException {
        return MappedFile.mappedFile(filename, chunkSize, (long)OS.pageSize());
    }

    public static MappedFile mappedFile(String filename, long chunkSize, long overlapSize) throws FileNotFoundException {
        return MappedFile.mappedFile(new File(filename), chunkSize, overlapSize);
    }

    public static MappedFile mappedFile(File file, long chunkSize, long overlapSize) throws FileNotFoundException {
        return new MappedFile(file, chunkSize, overlapSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedBytesStore acquireByteStore(long position) throws IOException {
        if (this.closed.get()) {
            throw new IOException("Closed");
        }
        int chunk = (int)(position / this.chunkSize);
        List<WeakReference<MappedBytesStore>> list = this.stores;
        synchronized (list) {
            MappedBytesStore mbs;
            while (this.stores.size() <= chunk) {
                this.stores.add(null);
            }
            WeakReference<MappedBytesStore> mbsRef = this.stores.get(chunk);
            if (mbsRef != null && (mbs = (MappedBytesStore)mbsRef.get()) != null && mbs.tryReserve()) {
                return mbs;
            }
            long minSize = ((long)chunk + 1L) * this.chunkSize + this.overlapSize;
            long size = this.fileChannel.size();
            if (size < minSize) {
                try (FileLock lock = this.fileChannel.lock();){
                    size = this.fileChannel.size();
                    if (size < minSize) {
                        this.raf.setLength(minSize);
                    }
                }
            }
            long mappedSize = this.chunkSize + this.overlapSize;
            long address = OS.map((FileChannel)this.fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)((long)chunk * this.chunkSize), (long)mappedSize);
            MappedBytesStore mbs2 = new MappedBytesStore(this, (long)chunk * this.chunkSize, address, mappedSize, this.chunkSize);
            this.stores.set(chunk, new WeakReference<MappedBytesStore>(mbs2));
            mbs2.reserve();
            return mbs2;
        }
    }

    public Bytes acquireBytes(long position) throws IOException {
        MappedBytesStore mbs = this.acquireByteStore(position);
        Bytes<Void> bytes = mbs.bytes();
        mbs.release();
        return bytes;
    }

    public void reserve() {
        this.refCount.reserve();
    }

    public void release() {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        List<WeakReference<MappedBytesStore>> list = this.stores;
        synchronized (list) {
            ReferenceCounted.releaseAll(this.stores);
        }
        this.release();
    }

    void performRelease() {
        for (int i = 0; i < this.stores.size(); ++i) {
            long count;
            WeakReference<MappedBytesStore> storeRef = this.stores.get(i);
            if (storeRef == null) continue;
            MappedBytesStore mbs = (MappedBytesStore)storeRef.get();
            if (mbs != null && (count = mbs.refCount()) > 0L) {
                mbs.release();
                if (count > 1L) continue;
            }
            this.stores.set(i, null);
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String referenceCounts() {
        StringBuilder sb = new StringBuilder();
        sb.append("refCount: ").append(this.refCount());
        for (WeakReference<MappedBytesStore> store : this.stores) {
            MappedBytesStore mbs;
            long count = 0L;
            if (store != null && (mbs = (MappedBytesStore)store.get()) != null) {
                count = mbs.refCount();
            }
            sb.append(", ").append(count);
        }
        return sb.toString();
    }

    public Bytes bytes() {
        return new MappedBytes(this);
    }

    public Bytes bytesThreadLocal() {
        Bytes bytes;
        WeakReference<Bytes> bytesRef = this.threadLocalBytes.get();
        if (bytesRef != null && (bytes = (Bytes)bytesRef.get()) != null) {
            return bytes;
        }
        bytes = this.bytes();
        this.threadLocalBytes.set(new WeakReference<Bytes>(bytes));
        return bytes;
    }

    public long capacity() {
        return this.capacity;
    }

    public String name() {
        return this.file.getName();
    }
}

