/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Primitives;
import net.openhft.chronicle.bytes.ReadAccess;

abstract class CharSequenceAccess
implements ReadAccess<CharSequence> {
    public static CharSequenceAccess charSequenceAccess(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? LittleEndianCharSequenceAccess.INSTANCE : BigEndianCharSequenceAccess.INSTANCE;
    }

    public static CharSequenceAccess nativeCharSequenceAccess() {
        return CharSequenceAccess.charSequenceAccess(ByteOrder.nativeOrder());
    }

    private static int ix(long offset) {
        return (int)(offset >> 1);
    }

    static long getLong(CharSequence input, long offset, int char0Off, int char1Off, int char2Off, int char3Off) {
        int base = CharSequenceAccess.ix(offset);
        long char0 = input.charAt(base + char0Off);
        long char1 = input.charAt(base + char1Off);
        long char2 = input.charAt(base + char2Off);
        long char3 = input.charAt(base + char3Off);
        return char0 | char1 << 16 | char2 << 32 | char3 << 48;
    }

    static long getUnsignedInt(CharSequence input, long offset, int char0Off, int char1Off) {
        int base = CharSequenceAccess.ix(offset);
        long char0 = input.charAt(base + char0Off);
        long char1 = input.charAt(base + char1Off);
        return char0 | char1 << 16;
    }

    private CharSequenceAccess() {
    }

    @Override
    public int readInt(CharSequence input, long offset) {
        return (int)this.readUnsignedInt(input, offset);
    }

    @Override
    public int readUnsignedShort(CharSequence input, long offset) {
        return input.charAt(CharSequenceAccess.ix(offset));
    }

    @Override
    public short readShort(CharSequence input, long offset) {
        return (short)input.charAt(CharSequenceAccess.ix(offset));
    }

    static int getUnsignedByte(CharSequence input, long offset, int shift) {
        return Primitives.unsignedByte(input.charAt(CharSequenceAccess.ix(offset)) >> shift);
    }

    @Override
    public byte readByte(CharSequence input, long offset) {
        return (byte)this.readUnsignedByte(input, offset);
    }

    static class BigEndianCharSequenceAccess
    extends CharSequenceAccess {
        static final CharSequenceAccess INSTANCE = new BigEndianCharSequenceAccess();

        private BigEndianCharSequenceAccess() {
        }

        @Override
        public long readLong(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getLong(input, offset, 3, 2, 1, 0);
        }

        @Override
        public long readUnsignedInt(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedInt(input, offset, 1, 0);
        }

        @Override
        public int readUnsignedByte(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1 ^ 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.BIG_ENDIAN;
        }
    }

    static class LittleEndianCharSequenceAccess
    extends CharSequenceAccess {
        static final CharSequenceAccess INSTANCE = new LittleEndianCharSequenceAccess();

        private LittleEndianCharSequenceAccess() {
        }

        @Override
        public long readLong(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getLong(input, offset, 0, 1, 2, 3);
        }

        @Override
        public long readUnsignedInt(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedInt(input, offset, 0, 1);
        }

        @Override
        public int readUnsignedByte(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.LITTLE_ENDIAN;
        }
    }
}

