/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.WriteAccess;

public interface ByteStringAppender<B extends ByteStringAppender<B, A, AT>, A extends WriteAccess<AT>, AT>
extends StreamingDataOutput<B, A, AT>,
Appendable {
    default public B append(char ch) {
        BytesUtil.appendUTF(this, ch);
        return (B)this;
    }

    default public B append(CharSequence cs) {
        return (B)this.append(cs, 0, cs.length());
    }

    default public B append(long value) {
        BytesUtil.append(this, value);
        return (B)this;
    }

    default public B append(float f) {
        BytesUtil.append(this, (double)f);
        return (B)this;
    }

    default public B append(double d) {
        BytesUtil.append(this, d);
        return (B)this;
    }

    default public B append(CharSequence cs, int start, int end) {
        BytesUtil.appendUTF(this, cs, start, end - start);
        return (B)this;
    }

    default public B append(long value, int digits) {
        BytesUtil.append((RandomDataOutput)((Object)this), this.position(), value, digits);
        this.skip(digits);
        return (B)this;
    }
}

