/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.InputStream;
import java.io.ObjectInput;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.core.Maths;

public interface StreamingDataInput<S extends StreamingDataInput<S, A, AT>, A extends ReadAccess<AT>, AT>
extends StreamingCommon<S, A, AT> {
    public UnderflowMode underflowMode();

    public S underflowMode(UnderflowMode var1);

    default public ObjectInput objectInput() {
        throw new UnsupportedOperationException();
    }

    default public InputStream inputStream() {
        throw new UnsupportedOperationException();
    }

    default public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(ACS sb) throws UTFDataFormatRuntimeException {
        BytesUtil.setLength(sb, 0);
        long len0 = BytesUtil.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesUtil.parseUTF(this, sb, len);
        return true;
    }

    default public long readStopBit() {
        return BytesUtil.readStopBit(this);
    }

    default public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte();

    default public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public short readShort();

    default public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt();

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong();

    public float readFloat();

    public double readDouble();

    public int peakVolatileInt();

    default public String readUTF\u0394() {
        return BytesUtil.readUTF\u0394(this);
    }

    public void read(byte[] var1);

    public void read(ByteBuffer var1);

    public int readVolatileInt();

    public long readVolatileLong();

    @Override
    public A access();

    public int peekUnsignedByte();

    public void nativeRead(long var1, long var3);
}

