/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.CharSequenceAccess;
import net.openhft.chronicle.bytes.HotSpotStringAccessor;
import net.openhft.chronicle.bytes.ReadAccess;

abstract class CharSequenceAccessor
implements Accessor.Read<CharSequence, CharSequence> {
    static final Accessor.Read<? super String, ?> stringAccessor = System.getProperty("java.vm.name").contains("HotSpot") && System.getProperty("java.version").compareTo("1.7.0_06") >= 0 ? HotSpotStringAccessor.INSTANCE : CharSequenceAccessor.nativeCharSequenceAccessor();
    static final CharSequenceAccessor LITTLE_ENDIAN = new CharSequenceAccessor(){

        @Override
        public ReadAccess<CharSequence> access(CharSequence source) {
            return CharSequenceAccess.LittleEndianCharSequenceAccess.INSTANCE;
        }
    };
    static final CharSequenceAccessor BIG_ENDIAN = new CharSequenceAccessor(){

        @Override
        public ReadAccess<CharSequence> access(CharSequence source) {
            return CharSequenceAccess.BigEndianCharSequenceAccess.INSTANCE;
        }
    };

    static CharSequenceAccessor nativeCharSequenceAccessor() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LITTLE_ENDIAN : BIG_ENDIAN;
    }

    private CharSequenceAccessor() {
    }

    @Override
    public CharSequence handle(CharSequence source) {
        return source;
    }

    @Override
    public long offset(CharSequence source, long index) {
        return index * 2L;
    }

    @Override
    public long size(long size) {
        return size * 2L;
    }
}

