/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Writer;
import net.openhft.chronicle.bytes.ByteStringWriter;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) {
        BytesUtil.appendUTF(this, ch);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) {
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(long value) {
        BytesUtil.append(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(float f) {
        BytesUtil.append(this, (double)f);
        return (B)this;
    }

    @NotNull
    default public B append(double d) {
        BytesUtil.append(this, d);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, int start, int end) {
        BytesUtil.appendUTF(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs));
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeUnsignedByte(c);
        }
        return (B)this;
    }

    default public B append8bit(@NotNull CharSequence cs, int offset, int length) {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)offset, (long)length));
        }
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(offset + i);
            if (c > 255) {
                c = 63;
            }
            this.writeUnsignedByte(c);
        }
        return (B)this;
    }

    @NotNull
    default public B append(long value, int digits) {
        BytesUtil.append((RandomDataOutput)((Object)this), this.writePosition(), value, digits);
        this.writeSkip(digits);
        return (B)this;
    }

    @NotNull
    default public B appendDateMillis(long timeInMillis) {
        BytesUtil.appendDateMillis(this, timeInMillis);
        return (B)this;
    }

    @NotNull
    default public B appendTimeMillis(long timeInMillis) {
        BytesUtil.appendTimeMillis(this, timeInMillis);
        return (B)this;
    }
}

