/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

interface ByteStringParser<B extends ByteStringParser<B>>
extends StreamingDataInput<B> {
    @ForceInline
    @NotNull
    default public String parseUTF(@NotNull StopCharTester stopCharTester) {
        return BytesUtil.parseUTF(this, stopCharTester);
    }

    @ForceInline
    default public void parseUTF(@NotNull Appendable sb, @NotNull StopCharTester stopCharTester) {
        BytesUtil.parseUTF((StreamingDataInput)this, sb, stopCharTester);
    }

    @ForceInline
    default public void parseUTF(@NotNull Appendable sb, @NotNull StopCharsTester stopCharsTester) {
        BytesUtil.parseUTF((StreamingDataInput)this, sb, stopCharsTester);
    }

    @ForceInline
    default public void parse8bit(Appendable sb, @NotNull StopCharsTester stopCharsTester) {
        if (sb instanceof StringBuilder) {
            BytesUtil.parse8bit((StreamingDataInput)this, (StringBuilder)sb, stopCharsTester);
        } else {
            BytesUtil.parse8bit((StreamingDataInput)this, (Bytes)sb, stopCharsTester);
        }
    }

    @ForceInline
    default public long parseLong() {
        return BytesUtil.parseLong(this);
    }

    @ForceInline
    default public double parseDouble() {
        return BytesUtil.parseDouble(this);
    }

    @ForceInline
    default public boolean skipTo(@NotNull StopCharTester tester) {
        return BytesUtil.skipTo(this, tester);
    }
}

