/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.openhft.chronicle.analytics.internal.InternalAnalyticsException;
import org.jetbrains.annotations.NotNull;

final class HttpUtil {
    private static final String THREAD_NAME = "chronicle-analytics-http-client";
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });

    private HttpUtil() {
    }

    public static void send(@NotNull String urlString, @NotNull String body, @NotNull Consumer<String> errorLogger, @NotNull Consumer<String> debugLogger) {
        EXECUTOR.execute(new Sender(urlString, body, errorLogger, debugLogger));
    }

    static String urlEncode(@NotNull String s, @NotNull Consumer<String> errorLogger) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            errorLogger.accept(e.toString());
            throw new InternalAnalyticsException("This should never happen as " + StandardCharsets.UTF_8.toString() + " should always be present.");
        }
    }

    static final class Sender
    implements Runnable {
        private final String urlString;
        private final String body;
        private final Consumer<String> errorLogger;
        private final Consumer<String> debugLogger;

        Sender(@NotNull String urlString, @NotNull String body, @NotNull Consumer<String> errorLogger, @NotNull Consumer<String> debugLogger) {
            this.urlString = urlString;
            this.body = body;
            this.errorLogger = errorLogger;
            this.debugLogger = debugLogger;
        }

        @Override
        public void run() {
            try {
                URL url = new URL(this.urlString);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                conn.setRequestProperty("Accept", "application/json");
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] output = this.body.getBytes(StandardCharsets.UTF_8);
                    os.write(output, 0, output.length);
                    os.flush();
                }
                var4_5 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    String sep = "";
                    while ((responseLine = br.readLine()) != null) {
                        response.append(sep).append(responseLine);
                        sep = " ";
                    }
                    String logMsg = response.toString().replaceAll("\\s+(?=\\S)", " ");
                    if (!logMsg.isEmpty()) {
                        this.debugLogger.accept(logMsg);
                    }
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                this.errorLogger.accept(ioe.toString());
            }
        }
    }
}

