/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.analytics.Analytics;
import net.openhft.chronicle.analytics.internal.AnalyticsConfiguration;
import net.openhft.chronicle.analytics.internal.ClientIdUtil;
import net.openhft.chronicle.analytics.internal.HttpUtil;
import net.openhft.chronicle.analytics.internal.JsonUtil;
import org.jetbrains.annotations.NotNull;

final class GoogleAnalytics
implements Analytics {
    private final AnalyticsConfiguration configuration;
    private final String clientId;
    private final AtomicLong lastSendAttemptNs = new AtomicLong();

    GoogleAnalytics(@NotNull AnalyticsConfiguration configuration) {
        this.configuration = configuration;
        this.clientId = ClientIdUtil.acquireClientId(configuration.clientIdFileName(), configuration.debugLogger());
    }

    @Override
    public void sendEvent(@NotNull String name, @NotNull Map<String, String> additionalEventParameters) {
        if (this.configuration.duration() > 0L) {
            long nextThresholdNs = this.lastSendAttemptNs.get() + this.configuration.timeUnit().toNanos(this.configuration.duration());
            if (System.nanoTime() < nextThresholdNs) {
                return;
            }
        }
        this.lastSendAttemptNs.set(System.nanoTime());
        if (additionalEventParameters.isEmpty()) {
            this.httpSend(name, this.configuration.eventParameters());
        } else {
            LinkedHashMap<String, String> mergedEventParameters = new LinkedHashMap<String, String>(this.configuration.eventParameters());
            mergedEventParameters.putAll(additionalEventParameters);
            this.httpSend(name, mergedEventParameters);
        }
    }

    private void httpSend(@NotNull String eventName, @NotNull Map<String, String> eventParameters) {
        String url = this.configuration.url() + "?measurement_id=" + HttpUtil.urlEncode(this.configuration.measurementId(), this.configuration.errorLogger()) + "&api_secret=" + HttpUtil.urlEncode(this.configuration.apiSecret(), this.configuration.errorLogger());
        String json = GoogleAnalytics.jsonFor(eventName, this.clientId, eventParameters, this.configuration.userProperties());
        HttpUtil.send(url, json, this.configuration.errorLogger(), this.configuration.debugLogger());
    }

    static String jsonFor(@NotNull String eventName, @NotNull String clientId, @NotNull Map<String, String> eventParameters, @NotNull Map<String, String> userProperties) {
        return Stream.of("{", JsonUtil.jsonElement(" ", "clientId", clientId) + ",", JsonUtil.jsonElement(" ", "userId", clientId) + ",", JsonUtil.jsonElement(" ", "nonPersonalizedAds", true) + ",", " " + JsonUtil.asElement("events") + ": [{", JsonUtil.jsonElement("  ", "name", eventName) + ",", "  " + JsonUtil.asElement("params") + ": {", GoogleAnalytics.renderMap(eventParameters, e -> JsonUtil.jsonElement("   ", (String)e.getKey(), e.getValue())), "  }", " }],", " " + JsonUtil.asElement("userProperties") + ": {", GoogleAnalytics.renderMap(userProperties, GoogleAnalytics::userProperty), " }", "}").collect(Collectors.joining(JsonUtil.nl()));
    }

    static String userProperty(Map.Entry<String, String> userProperty) {
        return String.format("  %s: {%n %s%n  }", JsonUtil.asElement(userProperty.getKey()), JsonUtil.jsonElement("   ", "value", userProperty.getValue()));
    }

    static String renderMap(@NotNull Map<String, String> map, @NotNull Function<Map.Entry<String, String>, String> mapper) {
        return map.entrySet().stream().map(mapper).collect(Collectors.joining(String.format(",%n", new Object[0])));
    }
}

