/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.Accessor;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.core.UnsafeMemory;

final class ArrayAccessors {
    static final long BYTE_BASE;
    private static final long BOOLEAN_BASE;
    private static final long CHAR_BASE;
    private static final long SHORT_BASE;
    private static final long INT_BASE;
    private static final long LONG_BASE;

    private ArrayAccessors() {
    }

    static {
        try {
            BOOLEAN_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(boolean[].class);
            BYTE_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(byte[].class);
            CHAR_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(char[].class);
            SHORT_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(short[].class);
            INT_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(int[].class);
            LONG_BASE = UnsafeMemory.MEMORY.arrayBaseOffset(long[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum Long implements Accessor.Full<long[], long[]>
    {
        INSTANCE;


        @Override
        public Access<long[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public long[] handle(long[] source) {
            return source;
        }

        @Override
        public long offset(long[] source, long index) {
            return LONG_BASE + index * 8L;
        }

        @Override
        public long size(long size) {
            return size * 8L;
        }
    }

    static enum Int implements Accessor.Full<int[], int[]>
    {
        INSTANCE;


        @Override
        public Access<int[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public int[] handle(int[] source) {
            return source;
        }

        @Override
        public long offset(int[] source, long index) {
            return INT_BASE + index * 4L;
        }

        @Override
        public long size(long size) {
            return size * 4L;
        }
    }

    static enum Short implements Accessor.Full<short[], short[]>
    {
        INSTANCE;


        @Override
        public Access<short[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public short[] handle(short[] source) {
            return source;
        }

        @Override
        public long offset(short[] source, long index) {
            return SHORT_BASE + index * 2L;
        }

        @Override
        public long size(long size) {
            return size * 2L;
        }
    }

    static enum Char implements Accessor.Full<char[], char[]>
    {
        INSTANCE;


        @Override
        public Access<char[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public char[] handle(char[] source) {
            return source;
        }

        @Override
        public long offset(char[] source, long index) {
            return CHAR_BASE + index * 2L;
        }

        @Override
        public long size(long size) {
            return size * 2L;
        }
    }

    static enum Byte implements Accessor.Full<byte[], byte[]>
    {
        INSTANCE;


        @Override
        public Access<byte[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public byte[] handle(byte[] source) {
            return source;
        }

        @Override
        public long offset(byte[] source, long index) {
            return BYTE_BASE + index;
        }
    }

    static enum Boolean implements Accessor.Full<boolean[], boolean[]>
    {
        INSTANCE;


        @Override
        public Access<boolean[]> access() {
            return NativeAccess.instance();
        }

        @Override
        public boolean[] handle(boolean[] source) {
            return source;
        }

        @Override
        public long offset(boolean[] source, long index) {
            return BOOLEAN_BASE + index;
        }
    }
}

