/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.algo.bytes.ByteBufferAccess;
import net.openhft.chronicle.algo.bytes.BytesAccesses;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;

public interface Access<T>
extends ReadAccess<T>,
WriteAccess<T> {
    public static <T> Access<T> nativeAccess() {
        return NativeAccess.instance();
    }

    public static Access<ByteBuffer> checkedByteBufferAccess() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <B extends BytesStore<B, U>, U> Access<B> checkedBytesStoreAccess() {
        return BytesAccesses.Full.INSTANCE;
    }

    public static ReadAccess<RandomDataInput> checkedRandomDataInputAccess() {
        return BytesAccesses.RandomDataInputReadAccessEnum.INSTANCE;
    }

    public static <S, T> void copy(ReadAccess<S> sourceAccess, S source, long sourceOffset, WriteAccess<T> targetAccess, T target, long targetOffset, long len) {
        targetAccess.writeFrom(target, targetOffset, sourceAccess, source, sourceOffset, len);
    }

    public static <T, U> boolean equivalent(ReadAccess<T> access1, T handle1, long offset1, ReadAccess<U> access2, U handle2, long offset2, long len) {
        return access1.compareTo(handle1, offset1, access2, handle2, offset2, len);
    }

    public boolean compareAndSwapInt(T var1, long var2, int var4, int var5);

    public boolean compareAndSwapLong(T var1, long var2, long var4, long var6);
}

