/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.hashing;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.algo.hashing.Primitives;

class XxHash_r39 {
    private static final XxHash_r39 INSTANCE = new XxHash_r39();
    private static final XxHash_r39 NATIVE_XX = LongHashFunction.NATIVE_LITTLE_ENDIAN ? INSTANCE : BigEndian.access$000();
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;

    private XxHash_r39() {
    }

    <T> long fetch64(ReadAccess<T> access, T in, long off) {
        return access.readLong(in, off);
    }

    <T> long fetch32(ReadAccess<T> access, T in, long off) {
        return access.readUnsignedInt(in, off);
    }

    <T> int fetch8(ReadAccess<T> access, T in, long off) {
        return access.readUnsignedByte(in, off);
    }

    long toLittleEndian(long v) {
        return v;
    }

    int toLittleEndian(int v) {
        return v;
    }

    short toLittleEndian(short v) {
        return v;
    }

    public <T> long xxHash64(long seed, T input, ReadAccess<T> access, long off, long length) {
        long hash;
        long remaining = length;
        if (remaining >= 32L) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += this.fetch64(access, input, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += this.fetch64(access, input, off + 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += this.fetch64(access, input, off + 16L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += this.fetch64(access, input, off + 24L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                off += 32L;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += length;
        while (remaining >= 8L) {
            long k1 = this.fetch64(access, input, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8L;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= this.fetch32(access, input, off) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4L;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= (long)this.fetch8(access, input, off) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++off;
        }
        return XxHash_r39.finalize(hash);
    }

    private static long finalize(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    public static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.SEEDLESS_INSTANCE;
    }

    public static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(seed);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private final long seed;
        private final long voidHash;

        private AsLongHashFunctionSeeded(long seed) {
            this.seed = seed;
            this.voidHash = XxHash_r39.finalize(seed + 2870177450012600261L);
        }

        @Override
        public long seed() {
            return this.seed;
        }

        @Override
        public long hashVoid() {
            return this.voidHash;
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        public static final AsLongHashFunction SEEDLESS_INSTANCE = new AsLongHashFunction();
        private static final long serialVersionUID = 0L;

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return SEEDLESS_INSTANCE;
        }

        public long seed() {
            return 0L;
        }

        @Override
        public long hashLong(long input) {
            input = NATIVE_XX.toLittleEndian(input);
            long hash = this.seed() + 2870177450012600261L + 8L;
            input *= -4417276706812531889L;
            input = Long.rotateLeft(input, 31);
            hash ^= (input *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            return XxHash_r39.finalize(hash);
        }

        @Override
        public long hashInt(int input) {
            input = NATIVE_XX.toLittleEndian(input);
            long hash = this.seed() + 2870177450012600261L + 4L;
            hash ^= Primitives.unsignedInt(input) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            return XxHash_r39.finalize(hash);
        }

        @Override
        public long hashShort(short input) {
            input = NATIVE_XX.toLittleEndian(input);
            long hash = this.seed() + 2870177450012600261L + 2L;
            hash ^= (long)Primitives.unsignedByte(input) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            hash ^= (long)Primitives.unsignedByte(input >> 8) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            return XxHash_r39.finalize(hash);
        }

        @Override
        public long hashChar(char input) {
            return this.hashShort((short)input);
        }

        @Override
        public long hashByte(byte input) {
            long hash = this.seed() + 2870177450012600261L + 1L;
            hash ^= (long)Primitives.unsignedByte(input) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            return XxHash_r39.finalize(hash);
        }

        @Override
        public long hashVoid() {
            return XxHash_r39.finalize(2870177450012600261L);
        }

        @Override
        public <T> long hash(T input, ReadAccess<T> access, long off, long len) {
            long seed = this.seed();
            if (access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
                return INSTANCE.xxHash64(seed, input, access, off, len);
            }
            return BigEndian.INSTANCE.xxHash64(seed, input, access, off, len);
        }
    }

    private static class BigEndian
    extends XxHash_r39 {
        private static final BigEndian INSTANCE = new BigEndian();

        private BigEndian() {
        }

        @Override
        <T> long fetch64(ReadAccess<T> access, T in, long off) {
            return Long.reverseBytes(super.fetch64(access, in, off));
        }

        @Override
        <T> long fetch32(ReadAccess<T> access, T in, long off) {
            return (long)Integer.reverseBytes(access.readInt(in, off)) & 0xFFFFFFFFL;
        }

        @Override
        long toLittleEndian(long v) {
            return Long.reverseBytes(v);
        }

        @Override
        int toLittleEndian(int v) {
            return Integer.reverseBytes(v);
        }

        @Override
        short toLittleEndian(short v) {
            return Short.reverseBytes(v);
        }
    }
}

