/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.lang.reflect.Field;
import net.openhft.chronicle.algo.bytes.Accessor;
import net.openhft.chronicle.algo.bytes.ArrayAccessors;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;

final class HotSpotStringAccessor
implements Accessor.Read<String, char[]> {
    public static final HotSpotStringAccessor INSTANCE = new HotSpotStringAccessor();
    private static final long valueOffset;

    private HotSpotStringAccessor() {
    }

    @Override
    public ReadAccess<char[]> access() {
        return NativeAccess.instance();
    }

    @Override
    public char[] handle(String source) {
        return (char[])NativeAccess.U.getObject(source, valueOffset);
    }

    @Override
    public long offset(String source, long index) {
        return ArrayAccessors.Char.INSTANCE.offset(null, index);
    }

    @Override
    public long size(long size) {
        return size * 2L;
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = NativeAccess.U.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

