/*
 * Decompiled with CFR 0.152.
 */
package software.chronicle;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="enforcer", defaultPhase=LifecyclePhase.VERIFY)
public class BinaryCompatibilityEnforcerPluginMogo
extends AbstractMojo {
    public static final String REPORT = "Report: ";
    public static final String BINARY_COMPATIBILITY = "Binary compatibility: ";
    public static final String BAR = "\n------------------------------------------------------------------------";
    private static final String BIN_SH = "/bin/sh";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="japi-compliance-checker -lib %s %s %s -report-path %s", readonly=true, required=false)
    private String expression;
    @Parameter(defaultValue="", required=false)
    private String referenceVersion;
    @Parameter(defaultValue="", required=false)
    private String artifactsURI;
    @Parameter(defaultValue="100.0", required=false)
    double binaryCompatibilityPercentageRequired;
    @Parameter(defaultValue="target")
    private String reportLocation;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("%s\nBINARY COMPATIBILITY ENFORCER - %s%s", BAR, this.project.getArtifactId(), BAR));
        if (!new File(BIN_SH).exists()) {
            this.getLog().info((CharSequence)"Not supported on Windows yet");
            return;
        }
        this.getLog().info((CharSequence)"Starting...");
        String finalName = this.project.getBuild().getFinalName();
        if (finalName.endsWith(".0-SNAPSHOT") || finalName.endsWith(".0") || finalName.endsWith("ea0-SNAPSHOT") || finalName.endsWith("ea0")) {
            return;
        }
        try {
            this.checkJavaAPIComplianceCheckerInstalled();
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
        Build build = this.project.getBuild();
        if (build == null) {
            throw new MojoExecutionException("build not found");
        }
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String outputDirectory = build.getOutputDirectory();
        this.getLog().info((CharSequence)this.referenceVersion);
        String pathToJar1 = this.referencePath(groupId, artifactId, outputDirectory);
        this.getLog().debug((CharSequence)("pathToJar1=" + pathToJar1));
        String directory = build.getDirectory();
        String pathToJar2 = String.format("%s%s%s.jar", directory, File.separator, finalName);
        this.getLog().debug((CharSequence)("pathToJar2=" + pathToJar2));
        this.checkBinaryCompatibility(pathToJar1, pathToJar2, artifactId);
    }

    private String referencePath(String groupId, String artifactId, String outputDirectory) throws MojoExecutionException {
        String pathToJar1 = null;
        if (this.isEmpty(this.referenceVersion)) {
            String version = this.project.getVersion();
            int i = version.indexOf(".");
            if (i != -1) {
                if ((i = version.indexOf(".", i + 1)) != -1) {
                    version = version.substring(0, i);
                    this.referenceVersion = version + ".0";
                    this.getLog().info((CharSequence)("setting referenceVersion=" + this.referenceVersion));
                    try {
                        pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(String.format("Please set <referenceVersion> config, can not download default version=%s of %s", this.referenceVersion, artifactId), e);
                    }
                }
                if (pathToJar1 == null) {
                    throw new MojoExecutionException("Please set <referenceVersion> config");
                }
            } else {
                pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
            }
        } else {
            pathToJar1 = this.downloadArtifact(groupId, artifactId, this.referenceVersion, outputDirectory).getAbsolutePath();
        }
        return pathToJar1;
    }

    private File downloadArtifact(String group, String artifactId, String version, String target) throws MojoExecutionException {
        File tempFile = new File(target, artifactId + "-" + version + ".jar");
        tempFile.delete();
        String command = String.format("mvn dependency:get -Dartifact=%s:%s:%s:jar -Dtransitive=false -Ddest=%s", group, artifactId, version, tempFile);
        this.getLog().info((CharSequence)command);
        BufferedReader stdError = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            stdInput.readLine();
            while (true) {
                String s1;
                if ((s1 = stdInput.readLine()) == null) {
                    this.dumpErrorToConsole(stdError);
                    throw new MojoExecutionException("unable to download using command=" + command);
                }
                if (s1.contains("BUILD SUCCESS")) break;
                this.getLog().debug((CharSequence)s1);
            }
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            this.dumpErrorToConsole(stdError);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            this.shutdown(p);
        }
    }

    private void checkBinaryCompatibility(String jar1, String jar2, String artifactName) throws MojoExecutionException {
        BufferedReader stdError = null;
        Process p = null;
        try {
            String s1;
            String reportOutput = this.constructReportOutputPath(artifactName, this.referenceVersion, this.project.getVersion());
            String command = String.format(this.expression, artifactName, jar1, jar2, reportOutput);
            this.getLog().info((CharSequence)command);
            p = new ProcessBuilder(BIN_SH, "-c", command).start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String binaryCompatibility = "";
            while (true) {
                if ((s1 = stdInput.readLine()) == null) {
                    this.dumpErrorToConsole(stdError);
                    throw new MojoExecutionException("failed to to successfully execute, command=" + command);
                }
                if (s1.startsWith(BINARY_COMPATIBILITY)) {
                    assert (s1.endsWith("%"));
                    binaryCompatibility = s1.substring(BINARY_COMPATIBILITY.length(), s1.length() - 1);
                }
                if (s1.startsWith(REPORT)) break;
                this.getLog().debug((CharSequence)s1);
            }
            String report = s1.substring(REPORT.length());
            if (Double.parseDouble(binaryCompatibility) < this.binaryCompatibilityPercentageRequired) {
                String buildNumber = System.getProperty("teamcity.agent.dotnet.build_id");
                String buildTypeId = System.getProperty("teamcity.buildType.id");
                String uri = buildNumber == null || this.isEmpty(this.artifactsURI) || this.isEmpty(buildTypeId) ? "file://" + new File(report).getAbsolutePath() : String.format("%s/%s/%s/%s", this.artifactsURI, buildTypeId, buildNumber + ":id", report);
                throw new MojoExecutionException(String.format("\n%s\nBINARY COMPATIBILITY ENFORCER - FAILURE - %s: %s%%  binary compatibility\nYour changes are only %s%% binary compatibility, this enforcer plugin requires at least %s%% binary compatibility,\n between %s and %s\nsee report \"%s\"%s", BAR, artifactName, binaryCompatibility, binaryCompatibility, this.binaryCompatibilityPercentageRequired, jar1, jar2, uri, BAR));
            }
            this.getLog().info((CharSequence)String.format("Whilst checking against %s", jar1));
            this.getLog().info((CharSequence)String.format("%s\nBINARY COMPATIBILITY ENFORCER - SUCCESSFUL - %s%s", BAR, artifactName, BAR));
            this.shutdown(p);
            return;
        }
        catch (IOException e) {
            try {
                this.dumpErrorToConsole(stdError);
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                this.shutdown(p);
                throw throwable;
            }
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private void dumpErrorToConsole(BufferedReader std) throws MojoExecutionException {
        if (std == null) {
            return;
        }
        try {
            String s1 = std.readLine();
            while (s1 != null) {
                this.getLog().warn((CharSequence)s1);
                s1 = std.readLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void checkJavaAPIComplianceCheckerInstalled() throws MojoExecutionException {
        Process p = null;
        BufferedReader stdError = null;
        try {
            p = new ProcessBuilder(BIN_SH, "-c", "japi-compliance-checker -l").start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            stdInput.readLine();
            String firstLine = stdInput.readLine();
            if (firstLine == null || !firstLine.startsWith("Java API Compliance Checker")) {
                throw new MojoExecutionException("Unable to load Java API Compliance Checker, please add it your $PATH and check its permissions.");
            }
            this.getLog().info((CharSequence)"Java API Compliance Checker - correctly installed");
            this.shutdown(p);
        }
        catch (IOException | MojoExecutionException e) {
            try {
                this.dumpErrorToConsole(stdError);
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                this.shutdown(p);
                throw throwable;
            }
        }
    }

    private String constructReportOutputPath(String artifactName, String oldVersion, String newVersion) {
        return this.project.getBasedir().getAbsolutePath() + String.format("/%s/compat_reports/%s/%s_to_%s/compat_report.html", this.reportLocation, artifactName, oldVersion, newVersion);
    }

    private void shutdown(Process p) {
        if (p != null) {
            p.destroy();
            try {
                p.waitFor(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                p.destroyForcibly();
            }
        }
    }
}

