/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.lang.reflect.Field;
import java.util.logging.Logger;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.impl.NullAffinity;
import net.openhft.affinity.impl.PosixJNAAffinity;
import net.openhft.affinity.impl.WindowsJNAAffinity;
import org.jetbrains.annotations.NotNull;

public enum AffinitySupport {

    @NotNull
    private static final IAffinity AFFINITY_IMPL;
    private static final Logger LOGGER;
    private static Boolean JNAAvailable;

    public static long getAffinity() {
        return AFFINITY_IMPL.getAffinity();
    }

    public static void setAffinity(long affinity) {
        AFFINITY_IMPL.setAffinity(affinity);
    }

    public static int getCpu() {
        return AFFINITY_IMPL.getCpu();
    }

    public static int getThreadId() {
        return AFFINITY_IMPL.getThreadId();
    }

    public static boolean isJNAAvailable() {
        if (JNAAvailable == null) {
            try {
                Class.forName("com.sun.jna.Platform");
                JNAAvailable = true;
            }
            catch (ClassNotFoundException ignored) {
                JNAAvailable = false;
            }
        }
        return JNAAvailable;
    }

    public static void setThreadId() {
        try {
            int threadId = AffinitySupport.getThreadId();
            Field tid = Thread.class.getDeclaredField("tid");
            tid.setAccessible(true);
            Thread thread = Thread.currentThread();
            tid.setLong(thread, threadId);
            Logger.getAnonymousLogger().info("Set " + thread.getName() + " to thread id " + threadId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        LOGGER = Logger.getLogger(AffinitySupport.class.getName());
        String osName = System.getProperty("os.name");
        if (osName.contains("Win") && AffinitySupport.isJNAAvailable() && WindowsJNAAffinity.LOADED) {
            LOGGER.fine("Using Windows JNA-based affinity control implementation");
            AFFINITY_IMPL = WindowsJNAAffinity.INSTANCE;
        } else if (osName.contains("x") && AffinitySupport.isJNAAvailable() && PosixJNAAffinity.LOADED) {
            LOGGER.fine("Using Posix JNA-based affinity control implementation");
            AFFINITY_IMPL = PosixJNAAffinity.INSTANCE;
        } else {
            LOGGER.info("Using dummy affinity control implementation");
            AFFINITY_IMPL = NullAffinity.INSTANCE;
        }
    }
}

