/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging.stats;

import com.sun.jbi.messaging.stats.TimedValue;
import java.util.EnumMap;
import java.util.Map;

public class HistoricalValues {
    private Map<Interval, TimedValue> values = new EnumMap<Interval, TimedValue>(Interval.class);

    public HistoricalValues() {
        for (Interval interval : Interval.values()) {
            this.values.put(interval, new TimedValue());
        }
    }

    public void addSample(long sample) {
        for (Map.Entry<Interval, TimedValue> value : this.values.entrySet()) {
            value.getValue().addSample(sample);
        }
    }

    public void zero() {
        for (Map.Entry<Interval, TimedValue> value : this.values.entrySet()) {
            value.getValue().zero();
        }
    }

    public Map<Interval, TimedValue> getValues() {
        return this.values;
    }

    public void zeroOutdated() {
        long now = System.currentTimeMillis();
        for (Map.Entry<Interval, TimedValue> value : this.values.entrySet()) {
            long last = value.getValue().getLastTime();
            if (last + value.getKey().getTime() <= now) continue;
            value.getValue().zero();
        }
    }

    public static enum Interval {
        GLOBAL(0L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L);

        long time;

        private Interval(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }
}

