/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.util.XMLUtil;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class EndpointReference {
    public static final String NS_URI_JBI = "http://java.sun.com/xml/ns/jbi";
    public static final String NS_PFIX_JBI = "jbi";
    public static final String NS_PFIX_SERVICE = "s";
    public static final String ELE_END_POINT_REFERENCE = "end-point-reference";
    public static final String ATTR_SERVICE_NAME = "service-name";
    public static final String ATTR_ENDPOINT_NAME = "end-point-name";

    public static DocumentFragment asReference(ServiceEndpoint endpoint) throws MessagingException {
        Document doc = XMLUtil.getInstance().newDocument();
        Element ele = doc.createElementNS(NS_URI_JBI, EndpointReference.qname(NS_PFIX_JBI, ELE_END_POINT_REFERENCE));
        ele.setAttribute("xmlns:jbi", NS_URI_JBI);
        ele.setAttribute("xmlns:s", endpoint.getServiceName().getNamespaceURI());
        ele.setAttributeNS(NS_URI_JBI, EndpointReference.qname(NS_PFIX_JBI, ATTR_SERVICE_NAME), EndpointReference.qname(NS_PFIX_SERVICE, endpoint.getServiceName().getLocalPart()));
        ele.setAttributeNS(NS_URI_JBI, EndpointReference.qname(NS_PFIX_JBI, ATTR_ENDPOINT_NAME), endpoint.getEndpointName());
        doc.appendChild(ele);
        DocumentFragment frag = doc.createDocumentFragment();
        frag.appendChild(doc.getDocumentElement());
        return frag;
    }

    private static String qname(String prefix, String value) {
        return prefix + ":" + value;
    }
}

