/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHolidayCalendar<E>
implements HolidayCalendar<E> {
    private static final long serialVersionUID = -8558686840806739645L;
    private static final CalendarComp CALENDAR_COMP = new CalendarComp();
    private static final DateComp DATE_COMP = new DateComp();
    private Set<E> holidays;
    private E earlyBoundary = null;
    private E lateBoundary = null;

    public DefaultHolidayCalendar() {
        this.holidays = Collections.emptySet();
    }

    public DefaultHolidayCalendar(Set<E> holidays, E earlyBoundary, E lateBoundary) {
        this.setHolidays(holidays);
        this.earlyBoundary = earlyBoundary;
        this.lateBoundary = lateBoundary;
    }

    public DefaultHolidayCalendar(Set<E> holidays) {
        this.setHolidays(holidays);
    }

    @Override
    public E getEarlyBoundary() {
        return this.earlyBoundary;
    }

    @Override
    public Set<E> getHolidays() {
        return this.holidays;
    }

    @Override
    public E getLateBoundary() {
        return this.lateBoundary;
    }

    @Override
    public void setEarlyBoundary(E earlyBoundary) {
        this.earlyBoundary = earlyBoundary;
    }

    @Override
    public final void setHolidays(Set<E> holidays) {
        if (holidays == null) {
            this.holidays = Collections.emptySet();
            return;
        }
        AbstractSet newSet = null;
        Iterator<E> it = holidays.iterator();
        if (it.hasNext()) {
            E obj = it.next();
            if (obj instanceof Date) {
                newSet = new TreeSet<Date>(DATE_COMP);
            } else if (obj instanceof Calendar) {
                newSet = new TreeSet<Calendar>(CALENDAR_COMP);
            }
        }
        if (newSet == null) {
            newSet = new HashSet<E>();
        }
        newSet.addAll(holidays);
        this.holidays = Collections.unmodifiableSet(newSet);
    }

    @Override
    public void setLateBoundary(E lateBoundary) {
        this.lateBoundary = lateBoundary;
    }

    @Override
    public boolean isHoliday(E date) {
        return this.holidays.contains(date);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CalendarComp
    implements Comparator<Calendar>,
    Serializable {
        private static final long serialVersionUID = 4783236154150397685L;

        private CalendarComp() {
        }

        @Override
        public int compare(Calendar cal1, Calendar cal2) {
            return (cal1.get(1) - cal2.get(1)) * 10000 + (cal1.get(2) - cal2.get(2)) * 100 + (cal1.get(5) - cal2.get(5));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DateComp
    implements Comparator<Date>,
    Serializable {
        private static final long serialVersionUID = 9079672835911375957L;

        private DateComp() {
        }

        @Override
        public int compare(Date date1, Date date2) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            return CALENDAR_COMP.compare(cal1, cal2);
        }
    }
}

