/*
 * Decompiled with CFR 0.152.
 */
package net.numa08.immutablefragmentstatepageradapter;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ImmutableFragmentStatePagerAdapter
extends PagerAdapter {
    private static final String TAG = "ifpa";
    private boolean DEBUG = false;
    private final FragmentManager mFragmentManager;
    private FragmentTransaction mCurTransaction = null;
    private ArrayList<Fragment.SavedState> mSavedState = new ArrayList();
    private ArrayList<Fragment> mFragments = new ArrayList();
    private Fragment mCurrentPrimaryItem = null;
    private Map<Fragment, Boolean> mFragmentIsDeleted = null;

    public ImmutableFragmentStatePagerAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
    }

    public abstract Fragment getItem(int var1);

    public void startUpdate(ViewGroup container) {
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment.SavedState fss;
        Fragment f;
        if (this.mFragments.size() > position && (f = this.mFragments.get(position)) != null) {
            return f;
        }
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        Fragment fragment = this.getItem(position);
        if (this.DEBUG) {
            Log.v((String)TAG, (String)("Adding item #" + position + ": f=" + fragment));
        }
        if (this.mSavedState.size() > position && (fss = this.mSavedState.get(position)) != null) {
            fragment.setInitialSavedState(fss);
        }
        while (this.mFragments.size() <= position) {
            this.mFragments.add(null);
        }
        fragment.setMenuVisibility(false);
        fragment.setUserVisibleHint(false);
        this.mFragments.set(position, fragment);
        this.mCurTransaction.add(container.getId(), fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        if (this.DEBUG) {
            Log.v((String)TAG, (String)("Removing item #" + position + ": f=" + object + " v=" + ((Fragment)object).getView()));
        }
        while (this.mSavedState.size() <= position) {
            this.mSavedState.add(null);
        }
        this.mSavedState.set(position, this.mFragmentManager.saveFragmentInstanceState(fragment));
        this.mFragments.set(position, null);
        this.mCurTransaction.remove(fragment);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.mCurrentPrimaryItem) {
            if (this.mCurrentPrimaryItem != null) {
                this.mCurrentPrimaryItem.setMenuVisibility(false);
                this.mCurrentPrimaryItem.setUserVisibleHint(false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                fragment.setUserVisibleHint(true);
            }
            this.mCurrentPrimaryItem = fragment;
        }
    }

    public void finishUpdate(ViewGroup container) {
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    public Parcelable saveState() {
        Bundle state = null;
        if (this.mSavedState.size() > 0) {
            state = new Bundle();
            Fragment.SavedState[] fss = new Fragment.SavedState[this.mSavedState.size()];
            this.mSavedState.toArray(fss);
            state.putParcelableArray("states", (Parcelable[])fss);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            Fragment f = this.mFragments.get(i);
            if (f == null || !f.isAdded()) continue;
            if (state == null) {
                state = new Bundle();
            }
            String key = "f" + i;
            this.mFragmentManager.putFragment(state, key, f);
        }
        return state;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state != null) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            Parcelable[] fss = bundle.getParcelableArray("states");
            this.mSavedState.clear();
            this.mFragments.clear();
            if (fss != null) {
                for (int i = 0; i < fss.length; ++i) {
                    this.mSavedState.add((Fragment.SavedState)fss[i]);
                }
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("f")) continue;
                int index = Integer.parseInt(key.substring(1));
                Fragment f = this.mFragmentManager.getFragment(bundle, key);
                if (f != null) {
                    while (this.mFragments.size() <= index) {
                        this.mFragments.add(null);
                    }
                    f.setMenuVisibility(false);
                    this.mFragments.set(index, f);
                    continue;
                }
                Log.w((String)TAG, (String)("Bad fragment at key " + key));
            }
        }
    }

    public int getItemPosition(Object object) {
        if (this.mFragments == null || this.mFragments.isEmpty()) {
            super.getItemPosition(object);
        }
        Fragment fragment = (Fragment)object;
        int position = this.mFragments.indexOf(fragment);
        if (this.mFragmentIsDeleted == null || this.mFragmentIsDeleted.isEmpty()) {
            return position;
        }
        boolean isDeleted = this.mFragmentIsDeleted.get(fragment);
        if (!isDeleted) {
            return position;
        }
        this.mFragmentIsDeleted = null;
        return -2;
    }

    public void removeItem(int position) {
        if (this.mFragments == null || this.mFragments.isEmpty()) {
            return;
        }
        if (position < 0 || position >= this.mFragments.size()) {
            this.throwIndexOutOfBoundsException(position);
        }
        this.mFragmentIsDeleted = new HashMap<Fragment, Boolean>(this.mFragments.size());
        for (int i = 0; i < this.mFragments.size(); ++i) {
            this.mFragmentIsDeleted.put(this.mFragments.get(i), i == position);
        }
        this.notifyDataSetChanged();
    }

    void throwIndexOutOfBoundsException(int position) {
        throw new IndexOutOfBoundsException("Invalid position " + position + " size is " + this.mFragments.size());
    }
}

