/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.noderunner.http.ContentType;
import net.noderunner.http.HttpUtil;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.ServerRequest;
import net.noderunner.http.servlet.BasicHttpSession;
import net.noderunner.http.servlet.HttpDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletRequestImpl
implements HttpServletRequest {
    private final ServerRequest request;
    private final InputStream inputStream;
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private BasicHttpSession session;
    private String serverName;
    private int serverPort;
    private String remoteHost;
    private int remotePort;
    private String remoteAddr;
    private String localAddr;
    private String localName;
    private int localPort;
    private String encoding;
    private boolean initParams = false;

    public HttpServletRequestImpl(ServerRequest request) throws IOException {
        this.request = request;
        this.encoding = this.getCharacterEncoding0();
        try {
            URI uri = new URI(request.getRequestLine().getRequestURI());
            String rq = uri.getRawQuery();
            if (rq != null) {
                this.parameters.putAll(HttpUtil.urlDecode(uri.getRawQuery()));
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.inputStream = HttpUtil.uncloseableInputStream(HttpUtil.wrapInputStream(request.getInputStream(), request.getHeaders()));
    }

    void serverSocket(ServerSocket ss) {
        this.serverName = ss.getLocalSocketAddress().toString();
        this.localName = ss.getLocalSocketAddress().toString();
        this.localAddr = ss.getLocalSocketAddress().toString();
        this.serverPort = ss.getLocalPort();
        this.localPort = ss.getLocalPort();
    }

    void remoteAddress(InetSocketAddress address) {
        this.remoteHost = address.getHostName();
        this.remoteAddr = address.getAddress().getHostAddress();
        this.remotePort = address.getPort();
    }

    public String getAuthType() {
        return null;
    }

    private String getURI() {
        String uri = this.request.getRequestLine().getRequestURI();
        return uri;
    }

    public String getContextPath() {
        return this.getURI();
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String fieldName) {
        try {
            Date date = new HttpDateFormat().parse(this.getHeader(fieldName));
            return date.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHeader(String fieldName) {
        return this.request.getHeaders().getFieldContent(fieldName);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.request.getHeaders().getNames());
    }

    public Enumeration<Object> getHeaders(String arg0) {
        throw new UnsupportedOperationException();
    }

    public int getIntHeader(String fieldName) {
        return Integer.parseInt(this.getHeader(fieldName));
    }

    public String getMethod() {
        return this.request.getRequestLine().getMethod().name();
    }

    public String getPathInfo() {
        return this.getURI();
    }

    public String getPathTranslated() {
        return this.getURI();
    }

    public String getQueryString() {
        return this.getURI();
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.getURI();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getURI());
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.getURI();
    }

    public HttpSession getSession() {
        if (this.session == null) {
            this.session = new BasicHttpSession();
        }
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        if (!create) {
            return this.session;
        }
        return this.getSession();
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    private String getCharacterEncoding0() {
        String ct = this.getHeader("content-type");
        if (ct == null) {
            return null;
        }
        String enc = ContentType.parse(ct).getParameterValue("encoding");
        return enc;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public int getContentLength() {
        String cl = this.getHeader("content-length");
        if (cl == null) {
            return -1;
        }
        return Integer.parseInt(cl);
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read(byte[] b, int off, int len) throws IOException {
                return HttpServletRequestImpl.this.inputStream.read(b, off, len);
            }

            public int read() throws IOException {
                return HttpServletRequestImpl.this.inputStream.read();
            }
        };
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(this.getLocale()));
    }

    public String getParameter(String key) {
        this.initParams();
        String[] sa = this.parameters.get(key);
        if (sa == null) {
            return null;
        }
        return sa[0];
    }

    public Map<String, String[]> getParameterMap() {
        this.initParams();
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        this.initParams();
        return Collections.enumeration(this.parameters.keySet());
    }

    private void initParams() {
        if (this.initParams) {
            return;
        }
        MessageHeaders headers = this.request.getHeaders();
        if (headers.contains(MessageHeader.MH_URL_ENCODED)) {
            try {
                this.parameters.putAll(HttpUtil.urlDecode(this.inputStream));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.initParams = true;
    }

    public String[] getParameterValues(String key) {
        return this.parameters.get(key);
    }

    public String getProtocol() {
        return "http";
    }

    public BufferedReader getReader() throws IOException {
        InputStreamReader isr = this.encoding == null ? new InputStreamReader(this.inputStream) : new InputStreamReader(this.inputStream, this.encoding);
        return new BufferedReader(isr);
    }

    public String getRealPath(String arg0) {
        return this.getURI();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    public String toString() {
        return super.toString() + " p=" + this.parameters;
    }
}

