/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.net.URL;
import java.util.Locale;
import net.noderunner.http.HttpException;
import net.noderunner.http.TokenUtil;

public class MessageHeader {
    public static final String FN_HOST = "host";
    public static final String FN_CONNECTION = "connection";
    public static final String FN_CONTENT_LENGTH = "content-length";
    public static final String FN_CONTENT_TYPE = "content-type";
    public static final String FN_LOCATION = "location";
    public static final String FN_REFERER = "referer";
    public static final String FN_TRANSFER_ENCODING = "transfer-encoding";
    public static final String FN_USER_AGENT = "user-agent";
    public static final String FN_SERVER = "server";
    public static final MessageHeader MH_TRANSFER_ENCODING_CHUNKED = new MessageHeader("transfer-encoding", "chunked");
    public static final MessageHeader MH_CONNECTION_KEEP_ALIVE = new MessageHeader("connection", "Keep-Alive");
    public static final MessageHeader MH_CONNECTION_CLOSE = new MessageHeader("connection", "close");
    public static final MessageHeader MH_URL_ENCODED = new MessageHeader("content-type", "application/x-www-form-urlencoded");
    public static final MessageHeader MH_USER_AGENT = new MessageHeader("user-agent", "ehttp/1.0");
    private final String fieldName;
    private final String fieldContent;
    private String toString;

    public static MessageHeader parse(String messageHeader) throws HttpException {
        if (messageHeader == null) {
            throw new IllegalArgumentException("Null messageHeader string");
        }
        int colonAt = messageHeader.indexOf(58);
        if (colonAt == -1) {
            throw new HttpException("No message-header colon found");
        }
        String fieldName = messageHeader.substring(0, colonAt).toLowerCase();
        String fieldValue = colonAt + 1 < messageHeader.length() ? messageHeader.substring(colonAt + 1).trim() : "";
        try {
            return new MessageHeader(fieldName, fieldValue);
        }
        catch (RuntimeException e) {
            throw new HttpException(e);
        }
    }

    public MessageHeader(String fieldName, String fieldValue) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Null fieldName");
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("Null fieldValue");
        }
        this.fieldName = fieldName.toLowerCase(Locale.ENGLISH);
        this.fieldContent = fieldValue.trim();
        if (!TokenUtil.isValidToken(fieldName)) {
            throw new IllegalArgumentException("Invalid characters in field-name " + fieldName);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessageHeader)) {
            return false;
        }
        MessageHeader h = (MessageHeader)other;
        return h.getFieldName().equals(this.getFieldName()) && h.getFieldContent().equals(this.getFieldContent());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldContent() {
        return this.fieldContent;
    }

    public int hashCode() {
        return this.fieldName.hashCode() ^ this.fieldContent.hashCode();
    }

    public static MessageHeader makeHostHeader(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        int port = url.getPort();
        String s = port == -1 ? url.getHost() : url.getHost() + ":" + port;
        return new MessageHeader(FN_HOST, s);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.getFieldName() + ':' + this.getFieldContent();
        }
        return this.toString;
    }
}

