/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.util;

import com.google.common.base.Optional;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ReflectionUtil {
    public static boolean hasSuperClass(Class<?> clazz) {
        return clazz != null && !clazz.equals(Object.class);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null || StringUtils.isBlank((CharSequence)methodName)) {
            return null;
        }
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            Method[] methods;
            for (Method method : methods = itr.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
                return method;
            }
            itr = itr.getSuperclass();
        }
        return null;
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        if (object == null || StringUtils.isBlank((CharSequence)methodName)) {
            return null;
        }
        Class<?> itr = object.getClass();
        while (ReflectionUtil.hasSuperClass(itr)) {
            Method[] methods;
            for (Method method : methods = itr.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
                return method;
            }
            itr = itr.getSuperclass();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object[] constructors = ReflectionUtil.getAllConstructorsOfClass(clazz, true);
        if (ArrayUtils.isEmpty((Object[])constructors)) {
            return null;
        }
        Optional<? extends Constructor<?>> optionalConstructor = ReflectionUtil.getDefaultConstructor(constructors);
        if (!optionalConstructor.isPresent()) {
            throw new RuntimeException("No default non parameter constructor found for class " + clazz.getName());
        }
        try {
            Object instance = ((Constructor)optionalConstructor.get()).newInstance(new Object[0]);
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor<?>[] getAllConstructorsOfClass(Class<?> clazz, boolean accessible) {
        if (clazz == null) {
            return null;
        }
        Object[] constructors = clazz.getDeclaredConstructors();
        if (ArrayUtils.isNotEmpty((Object[])constructors)) {
            AccessibleObject.setAccessible((AccessibleObject[])constructors, accessible);
        }
        return constructors;
    }

    private static Optional<? extends Constructor<?>> getDefaultConstructor(Constructor<?>[] constructors) {
        if (ArrayUtils.isEmpty((Object[])constructors)) {
            return Optional.absent();
        }
        for (Constructor<?> constructor : constructors) {
            if (!ArrayUtils.isEmpty((Object[])constructor.getParameterTypes())) continue;
            return Optional.of(constructor);
        }
        return Optional.absent();
    }
}

