/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.neoremind.dynamicproxy.Interceptor;
import net.neoremind.dynamicproxy.Invocation;
import net.neoremind.dynamicproxy.ObjectInvoker;
import net.neoremind.dynamicproxy.ObjectProvider;
import net.neoremind.dynamicproxy.template.CreatorTemplate;
import net.neoremind.dynamicproxy.util.ObjectUtil;
import net.neoremind.dynamicproxy.util.ProxyUtil;
import org.apache.commons.lang3.ArrayUtils;

public class JdkProxyCreator
extends CreatorTemplate {
    @Override
    public <T> T createDelegatorProxy(ClassLoader classLoader, ObjectProvider<?> delegateProvider, Class<?> ... proxyClasses) {
        Object result = Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new DelegatorInvocationHandler(delegateProvider));
        return (T)result;
    }

    @Override
    public <T> T createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        Object result = Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InterceptorInvocationHandler(target, interceptor));
        return (T)result;
    }

    @Override
    public <T> T createInvokerProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        Object result = Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InvokerInvocationHandler(invoker));
        return (T)result;
    }

    private static class ReflectionInvocation
    implements Invocation {
        private final Object proxy;
        private final Object target;
        private final Method method;
        private final Object[] arguments;

        public ReflectionInvocation(Object proxy, Object target, Method method, Object[] arguments) {
            this.proxy = proxy;
            this.target = target;
            this.method = method;
            this.arguments = ObjectUtil.defaultIfNull(ArrayUtils.clone((Object[])arguments), ProxyUtil.EMPTY_ARGUMENTS);
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object getProxy() {
            return this.proxy;
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return this.method.invoke(this.target, this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static class InvokerInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = 4277344818056348876L;
        private final ObjectInvoker invoker;

        public InvokerInvocationHandler(ObjectInvoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invoker.invoke(proxy, method, args);
        }
    }

    private static class InterceptorInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = -5079758027748139728L;
        private final Object target;
        private final Interceptor methodInterceptor;

        public InterceptorInvocationHandler(Object target, Interceptor methodInterceptor) {
            this.target = target;
            this.methodInterceptor = methodInterceptor;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            ReflectionInvocation invocation = new ReflectionInvocation(proxy, this.target, method, args);
            return this.methodInterceptor.intercept(invocation);
        }
    }

    private static class DelegatorInvocationHandler
    extends AbstractInvocationHandler {
        private static final long serialVersionUID = -7039084673621066448L;
        private final ObjectProvider<?> delegateProvider;

        protected DelegatorInvocationHandler(ObjectProvider<?> delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        @Override
        public Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegateProvider.getObject(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static abstract class AbstractInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = -5735923917525983672L;

        private AbstractInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ProxyUtil.isHashCode(method)) {
                return System.identityHashCode(proxy);
            }
            if (ProxyUtil.isEqualsMethod(method)) {
                return proxy == args[0];
            }
            return this.invokeImpl(proxy, method, args);
        }

        protected abstract Object invokeImpl(Object var1, Method var2, Object[] var3) throws Throwable;
    }
}

