/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.atomic.AtomicInteger;
import net.neoremind.dynamicproxy.Interceptor;
import net.neoremind.dynamicproxy.ObjectInvoker;
import net.neoremind.dynamicproxy.ObjectProvider;
import net.neoremind.dynamicproxy.exception.ProxyCreatorException;
import net.neoremind.dynamicproxy.support.DelegatorInvoker;
import net.neoremind.dynamicproxy.support.InterceptorInvoker;
import net.neoremind.dynamicproxy.support.Invokering;
import net.neoremind.dynamicproxy.template.ClassCache;
import net.neoremind.dynamicproxy.template.GeneratorTemplate;
import net.neoremind.dynamicproxy.template.SubclassCreatorTemplate;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class ASMCreator
extends SubclassCreatorTemplate {
    protected static final ClassCache PROXY_CLASS_CACHE = new ClassCache(new ProxyGenerator());

    @Override
    public <T> T createDelegatorProxy(ClassLoader classLoader, ObjectProvider<?> delegateProvider, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, new DelegatorInvoker(delegateProvider), proxyClasses);
    }

    @Override
    public <T> T createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, new InterceptorInvoker(target, interceptor), proxyClasses);
    }

    @Override
    public <T> T createInvokerProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        return this.createProxy(classLoader, new Invokering(invoker), proxyClasses);
    }

    private <T> T createProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        Class<?> proxyClass = PROXY_CLASS_CACHE.getProxyClass(classLoader, proxyClasses);
        try {
            Object result = proxyClass.getConstructor(ObjectInvoker.class).newInstance(invoker);
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ProxyGenerator
    extends GeneratorTemplate
    implements Opcodes {
        private static final AtomicInteger CLASS_NUMBER = new AtomicInteger(0);
        private static final String CLASSNAME_PREFIX = "CommonsProxyASM_";
        private static final String HANDLER_NAME = "__handler";
        private static final Type INVOKER_TYPE = Type.getType(ObjectInvoker.class);

        private ProxyGenerator() {
        }

        @Override
        public Class<?> generateProxyClass(ClassLoader classLoader, Class<?> ... proxyClasses) {
            Class<?> superclass = SubclassCreatorTemplate.getSuperclass(proxyClasses);
            String proxyName = CLASSNAME_PREFIX + CLASS_NUMBER.incrementAndGet();
            java.lang.reflect.Method[] implementationMethods = ProxyGenerator.getImplementationMethods(proxyClasses);
            Class[] interfaces = ASMCreator.toInterfaces(proxyClasses);
            String classFileName = proxyName.replace('.', '/');
            try {
                byte[] proxyBytes = ProxyGenerator.generateProxy(superclass, classFileName, implementationMethods, interfaces);
                return ProxyGenerator.loadClass(classLoader, proxyName, proxyBytes);
            }
            catch (Exception e) {
                throw new ProxyCreatorException(e);
            }
        }

        private static byte[] generateProxy(Class<?> classToProxy, String proxyName, java.lang.reflect.Method[] methods, Class<?> ... interfaces) throws ProxyCreatorException {
            ClassWriter cw = new ClassWriter(1);
            Type proxyType = Type.getObjectType((String)proxyName);
            String[] interfaceNames = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceNames[i] = Type.getType(interfaces[i]).getInternalName();
            }
            Type superType = Type.getType(classToProxy);
            cw.visit(50, 33, proxyType.getInternalName(), null, superType.getInternalName(), interfaceNames);
            cw.visitField(18, HANDLER_NAME, INVOKER_TYPE.getDescriptor(), null, null).visitEnd();
            ProxyGenerator.init(cw, proxyType, superType);
            for (java.lang.reflect.Method method : methods) {
                ProxyGenerator.processMethod(cw, method, proxyType, HANDLER_NAME);
            }
            return cw.toByteArray();
        }

        private static void init(ClassWriter cw, Type proxyType, Type superType) {
            GeneratorAdapter mg = new GeneratorAdapter(1, new Method("<init>", Type.VOID_TYPE, new Type[]{INVOKER_TYPE}), null, null, (ClassVisitor)cw);
            mg.loadThis();
            mg.invokeConstructor(superType, Method.getMethod((String)"void <init> ()"));
            mg.loadThis();
            mg.loadArg(0);
            mg.putField(proxyType, HANDLER_NAME, INVOKER_TYPE);
            mg.returnValue();
            mg.endMethod();
        }

        private static void processMethod(ClassWriter cw, java.lang.reflect.Method method, Type proxyType, String handlerName) throws ProxyCreatorException {
            Type[] exceptionTypes = ProxyGenerator.getTypes(method.getExceptionTypes());
            int access = 5 & method.getModifiers();
            Method m = Method.getMethod((java.lang.reflect.Method)method);
            GeneratorAdapter mg = new GeneratorAdapter(access, m, null, ProxyGenerator.getTypes(method.getExceptionTypes()), (ClassVisitor)cw);
            Label tryBlock = exceptionTypes.length > 0 ? mg.mark() : null;
            mg.push(Type.getType(method.getDeclaringClass()));
            mg.push(method.getName());
            mg.push(Type.getArgumentTypes((java.lang.reflect.Method)method).length);
            Type classType = Type.getType(Class.class);
            mg.newArray(classType);
            for (int i = 0; i < Type.getArgumentTypes((java.lang.reflect.Method)method).length; ++i) {
                mg.dup();
                mg.push(i);
                mg.push(Type.getArgumentTypes((java.lang.reflect.Method)method)[i]);
                mg.arrayStore(classType);
            }
            mg.invokeVirtual(classType, Method.getMethod((String)"java.lang.reflect.Method getDeclaredMethod(String, Class[])"));
            mg.loadThis();
            mg.getField(proxyType, handlerName, INVOKER_TYPE);
            mg.swap();
            mg.loadThis();
            mg.swap();
            mg.push(Type.getArgumentTypes((java.lang.reflect.Method)method).length);
            Type objectType = Type.getType(Object.class);
            mg.newArray(objectType);
            for (int i = 0; i < Type.getArgumentTypes((java.lang.reflect.Method)method).length; ++i) {
                mg.dup();
                mg.push(i);
                mg.loadArg(i);
                mg.valueOf(Type.getArgumentTypes((java.lang.reflect.Method)method)[i]);
                mg.arrayStore(objectType);
            }
            mg.invokeInterface(INVOKER_TYPE, Method.getMethod((String)"Object invoke(Object, java.lang.reflect.Method, Object[])"));
            mg.unbox(Type.getReturnType((java.lang.reflect.Method)method));
            mg.returnValue();
            if (exceptionTypes.length > 0) {
                Type caughtExceptionType = Type.getType(InvocationTargetException.class);
                mg.catchException(tryBlock, mg.mark(), caughtExceptionType);
                Label throwCause = new Label();
                mg.invokeVirtual(caughtExceptionType, Method.getMethod((String)"Throwable getCause()"));
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    mg.dup();
                    mg.push(exceptionTypes[i]);
                    mg.swap();
                    mg.invokeVirtual(classType, Method.getMethod((String)"boolean isInstance(Object)"));
                    mg.ifZCmp(154, throwCause);
                }
                int cause = mg.newLocal(Type.getType(Exception.class));
                mg.storeLocal(cause);
                Type undeclaredType = Type.getType(UndeclaredThrowableException.class);
                mg.newInstance(undeclaredType);
                mg.dup();
                mg.loadLocal(cause);
                mg.invokeConstructor(undeclaredType, new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Throwable.class)}));
                mg.throwException();
                mg.mark(throwCause);
                mg.throwException();
            }
            mg.endMethod();
        }

        private static Type[] getTypes(Class<?> ... src) {
            Type[] result = new Type[src.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Type.getType(src[i]);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Class<?> loadClass(ClassLoader loader, String className, byte[] b) {
            java.lang.reflect.Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            try {
                Class clazz = (Class)method.invoke((Object)loader, className, b, 0, b.length);
                if (!accessible) {
                    method.setAccessible(false);
                }
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    if (!accessible) {
                        method.setAccessible(false);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

