/*
 * Decompiled with CFR 0.152.
 */
package net.neoremind.dynamicproxy;

import java.util.Arrays;
import java.util.ServiceLoader;
import net.neoremind.dynamicproxy.Interceptor;
import net.neoremind.dynamicproxy.ObjectInvoker;
import net.neoremind.dynamicproxy.ObjectProvider;
import net.neoremind.dynamicproxy.ProxyCreator;

public class DefaultProxyCreator
implements ProxyCreator {
    public static final DefaultProxyCreator INSTANCE = new DefaultProxyCreator();
    private static final ServiceLoader<ProxyCreator> SERVICES = ServiceLoader.load(ProxyCreator.class);

    @Override
    public boolean canProxy(Class<?> ... proxyClasses) {
        for (ProxyCreator proxyFactory : SERVICES) {
            if (!proxyFactory.canProxy(proxyClasses)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T createDelegatorProxy(ObjectProvider<?> delegateProvider, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createDelegatorProxy(delegateProvider, proxyClasses);
        return result;
    }

    @Override
    public <T> T createDelegatorProxy(ClassLoader classLoader, ObjectProvider<?> delegateProvider, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createDelegatorProxy(classLoader, delegateProvider, proxyClasses);
        return result;
    }

    @Override
    public <T> T createInterceptorProxy(Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createInterceptorProxy(target, interceptor, proxyClasses);
        return result;
    }

    @Override
    public <T> T createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createInterceptorProxy(classLoader, target, interceptor, proxyClasses);
        return result;
    }

    @Override
    public <T> T createInvokerProxy(ObjectInvoker invoker, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createInvokerProxy(invoker, proxyClasses);
        return result;
    }

    @Override
    public <T> T createInvokerProxy(ClassLoader classLoader, ObjectInvoker invoker, Class<?> ... proxyClasses) {
        Object result = this.getCapableProxyCreator(proxyClasses).createInvokerProxy(classLoader, invoker, proxyClasses);
        return result;
    }

    private ProxyCreator getCapableProxyCreator(Class<?> ... proxyClasses) {
        for (ProxyCreator proxyFactory : SERVICES) {
            if (!proxyFactory.canProxy(proxyClasses)) continue;
            return proxyFactory;
        }
        throw new IllegalArgumentException("Could not proxy " + Arrays.toString(proxyClasses));
    }
}

