/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.BaseBundle;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class Bundle
extends BaseBundle
implements Parcelable,
Cloneable {
    public static Parcelable.Creator<Bundle> CREATOR = new Parcelable.ClassLoaderCreator<Bundle>(){

        @Override
        public Bundle createFromParcel(Parcel source, ClassLoader loader) {
            int size = source.readInt();
            Bundle bundle = new Bundle(loader, size);
            block22: for (int i = 0; i < size; ++i) {
                BaseBundle.Type type;
                String key = source.readString();
                if (bundle.readFromParcel(source, key, type = BaseBundle.Type.valueOf(source.readInt()))) continue;
                switch (type) {
                    case BUNDLE: {
                        bundle.put(key, type, this.createFromParcel(source));
                        continue block22;
                    }
                    case BYTE: {
                        bundle.put(key, type, source.readByte());
                        continue block22;
                    }
                    case BYTE_ARRAY: {
                        bundle.put(key, type, source.createByteArray());
                        continue block22;
                    }
                    case CHAR: {
                        bundle.put(key, type, Character.valueOf((char)source.readInt()));
                        continue block22;
                    }
                    case CHAR_ARRAY: {
                        bundle.put(key, type, source.createCharArray());
                        continue block22;
                    }
                    case CHAR_SEQUENCE: {
                        bundle.put(key, type, source.readString());
                        continue block22;
                    }
                    case CHAR_SEQUENCE_ARRAY: {
                        String[] strings = source.createStringArray();
                        Object out = new CharSequence[strings.length];
                        System.arraycopy(strings, 0, out, 0, strings.length);
                        bundle.put(key, type, out);
                        continue block22;
                    }
                    case FLOAT: {
                        bundle.put(key, type, Float.valueOf(source.readFloat()));
                        continue block22;
                    }
                    case FLOAT_ARRAY: {
                        bundle.put(key, type, source.createFloatArray());
                        continue block22;
                    }
                    case INT_ARRAY_LIST: {
                        int[] ints = source.createIntArray();
                        Object out = new ArrayList(ints.length);
                        for (int v : ints) {
                            ((ArrayList)out).add(v);
                        }
                        bundle.put(key, type, out);
                        continue block22;
                    }
                    case PARCELABLE: {
                        bundle.put(key, type, source.readParcelable(loader));
                        continue block22;
                    }
                    case PARCELABLE_ARRAY: {
                        bundle.put(key, type, source.readParcelableArray(loader));
                        continue block22;
                    }
                    case PARCELABLE_ARRAY_LIST: {
                        ArrayList out = new ArrayList();
                        Collections.addAll(out, source.readParcelableArray(loader));
                        bundle.put(key, type, out);
                        continue block22;
                    }
                    case SERIALIZABLE: {
                        try {
                            ByteArrayInputStream bais = new ByteArrayInputStream(source.createByteArray());
                            ObjectInputStream ios = new ObjectInputStream(bais);
                            bundle.put(key, type, ios.readObject());
                            ios.close();
                            continue block22;
                        }
                        catch (IOException ie) {
                            throw new ParcelFormatException("IOException: " + ie.getMessage());
                        }
                        catch (ClassNotFoundException e) {
                            throw new ParcelFormatException("ClassNotFoundException: " + e.getMessage());
                        }
                    }
                    case SHORT: {
                        bundle.put(key, type, (short)source.readInt());
                        continue block22;
                    }
                    case SHORT_ARRAY: {
                        int[] ints = source.createIntArray();
                        Object out = new short[ints.length];
                        for (int j = 0; j < ints.length; ++j) {
                            out[j] = (CharSequence)((short)ints[j]);
                        }
                        bundle.put(key, type, out);
                        continue block22;
                    }
                    case STRING_ARRAY_LIST: {
                        String[] strings = source.createStringArray();
                        Object out = new ArrayList(strings.length);
                        Collections.addAll(out, strings);
                        bundle.put(key, type, out);
                        continue block22;
                    }
                    default: {
                        throw new ParcelFormatException("Unknown type for bundle deserialization " + (Object)((Object)type));
                    }
                }
            }
            return bundle;
        }

        @Override
        public Bundle createFromParcel(Parcel source) {
            return this.createFromParcel(source, ClassLoader.getSystemClassLoader());
        }

        public Bundle[] newArray(int size) {
            return new Bundle[size];
        }
    };
    public static Bundle EMPTY = new Bundle(Collections.EMPTY_MAP);
    private static final int kDefaultSize = 256;
    private boolean isWriting = false;
    private final ClassLoader loader;

    public Bundle() {
        this(null, 256);
    }

    public Bundle(ClassLoader loader) {
        this(loader, 256);
    }

    public Bundle(int capacity) {
        this(null, capacity);
    }

    public Bundle(PersistableBundle bundle) {
        this(null, bundle.size());
        this.putAll(bundle);
    }

    public Bundle(Bundle bundle) {
        this(bundle.loader, bundle.size());
        this.map.putAll(bundle.map);
    }

    public void putAll(Bundle bundle) {
        this.map.putAll(bundle.map);
    }

    @Override
    public void putAll(PersistableBundle bundle) {
        for (Map.Entry i : bundle.map.entrySet()) {
            if (((Pair)i.getValue()).first == BaseBundle.Type.PERSISTABLE_BUNDLE) {
                this.putBundle((String)i.getKey(), new Bundle((PersistableBundle)((Pair)i.getValue()).second));
                continue;
            }
            this.map.put(i.getKey(), i.getValue());
        }
    }

    public boolean hasFileDescriptors() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public Bundle getBundle(String key) {
        return this.get(key, BaseBundle.Type.BUNDLE, null);
    }

    public void putBundle(String key, Bundle value) {
        this.put(key, BaseBundle.Type.BUNDLE, value);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.get(key, BaseBundle.Type.BYTE, defaultValue);
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public void putByte(String key, byte b) {
        this.put(key, BaseBundle.Type.BYTE, b);
    }

    public byte[] getByteArray(String key) {
        return this.get(key, BaseBundle.Type.BYTE_ARRAY, null);
    }

    public void putByteArray(String key, byte[] value) {
        this.put(key, BaseBundle.Type.BYTE_ARRAY, value);
    }

    public char getChar(String key, char defaultValue) {
        return this.get(key, BaseBundle.Type.CHAR, Character.valueOf(defaultValue)).charValue();
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public void putChar(String key, char c) {
        this.put(key, BaseBundle.Type.CHAR, Character.valueOf(c));
    }

    public char[] getCharArray(String key) {
        return this.get(key, BaseBundle.Type.CHAR_ARRAY, null);
    }

    public void putCharArray(String key, char[] value) {
        this.put(key, BaseBundle.Type.CHAR_ARRAY, value);
    }

    public CharSequence getCharSequence(String key, CharSequence defaultValue) {
        return this.get(key, BaseBundle.Type.CHAR_SEQUENCE, defaultValue);
    }

    public CharSequence getCharSequence(String key) {
        return this.getCharSequence(key, null);
    }

    public void putCharSequence(String key, CharSequence value) {
        this.put(key, BaseBundle.Type.CHAR_SEQUENCE, value);
    }

    public CharSequence[] getCharSequenceArray(String key) {
        return this.get(key, BaseBundle.Type.CHAR_SEQUENCE_ARRAY, null);
    }

    public void putCharSequenceArray(String key, CharSequence[] value) {
        this.put(key, BaseBundle.Type.CHAR_SEQUENCE_ARRAY, value);
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key, BaseBundle.Type.FLOAT, Float.valueOf(defaultValue)).floatValue();
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public void putFloat(String key, float value) {
        this.put(key, BaseBundle.Type.FLOAT, Float.valueOf(value));
    }

    public float[] getFloatArray(String key) {
        return this.get(key, BaseBundle.Type.FLOAT_ARRAY, null);
    }

    public void putFloatArray(String key, float[] value) {
        this.put(key, BaseBundle.Type.FLOAT_ARRAY, value);
    }

    public ArrayList<Integer> getIntegerArrayList(String key) {
        return this.get(key, BaseBundle.Type.INT_ARRAY_LIST, null);
    }

    public void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.put(key, BaseBundle.Type.INT_ARRAY_LIST, value);
    }

    public <T extends Parcelable> T getParcelable(String key) {
        return (T)((Parcelable)this.get(key, BaseBundle.Type.PARCELABLE, null));
    }

    public <T extends Parcelable> void putParcelable(String key, T value) {
        this.put(key, BaseBundle.Type.PARCELABLE, value);
    }

    public <T extends Parcelable> T[] getParcelableArray(String key) {
        return this.get(key, BaseBundle.Type.PARCELABLE_ARRAY, null);
    }

    public <T extends Parcelable> void putParcelableArray(String key, T[] value) {
        this.put(key, BaseBundle.Type.PARCELABLE_ARRAY, value);
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String key) {
        return this.get(key, BaseBundle.Type.PARCELABLE_ARRAY_LIST, null);
    }

    public <T extends Parcelable> void putParcelableArrayList(String key, ArrayList<T> value) {
        this.put(key, BaseBundle.Type.PARCELABLE_ARRAY_LIST, value);
    }

    public <T extends Serializable> T getSerializable(String key) {
        return (T)((Serializable)this.get(key, BaseBundle.Type.SERIALIZABLE, null));
    }

    public <T extends Serializable> void putSerializable(String key, T value) {
        this.put(key, BaseBundle.Type.SERIALIZABLE, value);
    }

    public short getShort(String key, short defaultValue) {
        return this.get(key, BaseBundle.Type.SHORT, defaultValue);
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public void putShort(String key, short value) {
        this.put(key, BaseBundle.Type.SHORT, value);
    }

    public short[] getShortArray(String key) {
        return this.get(key, BaseBundle.Type.SHORT_ARRAY, null);
    }

    public void putShortArray(String key, short[] value) {
        this.put(key, BaseBundle.Type.SHORT_ARRAY, value);
    }

    public ArrayList<String> getStringArrayList(String key) {
        return this.get(key, BaseBundle.Type.STRING_ARRAY_LIST, null);
    }

    public void putStringArrayList(String key, ArrayList<String> value) {
        this.put(key, BaseBundle.Type.STRING_ARRAY_LIST, value);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Map map = this.map;
        synchronized (map) {
            if (this.isWriting) {
                throw new BadParcelableException("Trying to write with circular references.");
            }
            try {
                this.isWriting = true;
                dest.writeInt(this.size());
                block27: for (Map.Entry entry : this.map.entrySet()) {
                    if (this.writeToParcel(dest, (String)entry.getKey(), (BaseBundle.Type)((Object)((Pair)entry.getValue()).first), ((Pair)entry.getValue()).second)) continue;
                    Object value = ((Pair)entry.getValue()).second;
                    switch ((BaseBundle.Type)((Object)((Pair)entry.getValue()).first)) {
                        case BUNDLE: {
                            Bundle b = (Bundle)Bundle.cast(value);
                            b.writeToParcel(dest, flags);
                            continue block27;
                        }
                        case BYTE: {
                            dest.writeByte((Byte)Bundle.cast(value));
                            continue block27;
                        }
                        case BYTE_ARRAY: {
                            dest.writeByteArray((byte[])Bundle.cast(value));
                            continue block27;
                        }
                        case CHAR: {
                            dest.writeInt(((Character)value).charValue());
                            continue block27;
                        }
                        case CHAR_ARRAY: {
                            dest.writeCharArray((char[])Bundle.cast(value));
                            continue block27;
                        }
                        case CHAR_SEQUENCE: {
                            dest.writeString(value == null ? null : value.toString());
                            continue block27;
                        }
                        case CHAR_SEQUENCE_ARRAY: {
                            int i;
                            CharSequence[] sequences = (CharSequence[])Bundle.cast(value);
                            String[] strings = new String[sequences.length];
                            for (i = 0; i < sequences.length; ++i) {
                                strings[i] = sequences[i] == null ? null : sequences[i].toString();
                            }
                            dest.writeStringArray(strings);
                            continue block27;
                        }
                        case FLOAT: {
                            dest.writeFloat(((Float)Bundle.cast(value)).floatValue());
                            continue block27;
                        }
                        case FLOAT_ARRAY: {
                            dest.writeFloatArray((float[])Bundle.cast(value));
                            continue block27;
                        }
                        case INT_ARRAY_LIST: {
                            int i;
                            ArrayList list = (ArrayList)Bundle.cast(value);
                            int[] ints = new int[list.size()];
                            for (i = 0; i < list.size(); ++i) {
                                ints[i] = (Integer)list.get(i);
                            }
                            dest.writeIntArray(ints);
                            continue block27;
                        }
                        case PARCELABLE: {
                            dest.writeParcelable((Parcelable)Bundle.cast(value), 0);
                            continue block27;
                        }
                        case PARCELABLE_ARRAY: {
                            dest.writeParcelableArray((Parcelable[])Bundle.cast(value), 0);
                            continue block27;
                        }
                        case PARCELABLE_ARRAY_LIST: {
                            ArrayList alp = (ArrayList)Bundle.cast(value);
                            dest.writeParcelableArray(alp.toArray(new Parcelable[alp.size()]), 0);
                            continue block27;
                        }
                        case SERIALIZABLE: {
                            try {
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                ObjectOutputStream oos = new ObjectOutputStream(baos);
                                oos.writeObject(value);
                                oos.flush();
                                dest.writeByteArray(baos.toByteArray());
                                continue block27;
                            }
                            catch (IOException e) {
                                throw new BadParcelableException("Value at key " + (String)entry.getKey() + " is not serializable.");
                            }
                        }
                        case SHORT: {
                            dest.writeInt(((Short)value).shortValue());
                            continue block27;
                        }
                        case SHORT_ARRAY: {
                            int i;
                            short[] shorts = (short[])Bundle.cast(value);
                            int[] ints = new int[shorts.length];
                            for (i = 0; i < shorts.length; ++i) {
                                ints[i] = shorts[i];
                            }
                            dest.writeIntArray(ints);
                            continue block27;
                        }
                        case STRING_ARRAY_LIST: {
                            ArrayList als = (ArrayList)Bundle.cast(value);
                            dest.writeStringArray(als.toArray(new String[als.size()]));
                            continue block27;
                        }
                    }
                    throw new BadParcelableException("Unknown type for bundle serialization " + ((Pair)entry.getValue()).first);
                }
            }
            finally {
                this.isWriting = false;
            }
        }
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }

    private Bundle(Map<String, Pair<BaseBundle.Type, Object>> map) {
        super(map);
        this.loader = ClassLoader.getSystemClassLoader();
    }

    private Bundle(ClassLoader loader, int capacity) {
        super(capacity);
        this.loader = loader != null ? loader : ClassLoader.getSystemClassLoader();
    }
}

