/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.events;

import com.testflightapp.lib.TestFlight;
import com.testflightapp.lib.events.SessionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionEndEvent
extends SessionEvent {
    private static final long serialVersionUID = -619539239381354346L;
    private final List<EventLogLine> mLogs;

    public SessionEndEvent(long l, List<EventLogLine> list) {
        super(l, "session_end");
        this.mLogs = list;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (TestFlight.sendsLogs() && this.mLogs != null && this.mLogs.size() > 0) {
            Object[] objectArray = new Object[this.mLogs.size()];
            for (int i = 0; i < this.mLogs.size(); ++i) {
                EventLogLine eventLogLine = this.mLogs.get(i);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("Message", eventLogLine.mLogLine);
                hashMap.put("Time", eventLogLine.mTimestamp);
                objectArray[i] = hashMap;
            }
            map.put("log", objectArray);
        }
        return map;
    }

    public static class EventLogLine
    implements Serializable {
        private static final long serialVersionUID = -3450217302213749728L;
        public final long mTimestamp;
        public final String mLogLine;

        public EventLogLine(String string) {
            this.mLogLine = string;
            this.mTimestamp = System.currentTimeMillis() / 1000L;
        }
    }
}

