/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Patterns;
import android.view.Display;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.bzutils.AppRate;
import com.bzutils.Localizator;
import com.bzutils.LogBZ;
import com.bzutils.PhoneBookMethods;
import com.bzutils.exception.BZLocationException;
import com.bzutils.exception.ShareAppNotAvailable;
import com.bzutils.listener.ContactsListener;
import com.bzutils.model.BZPeriod;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"NewApi"})
public class BZUtils {
    public static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    public static final int DEFAULT_DECIMAL_NUMBERS = 2;
    public static final String WHATSAPP_PACKAGE = "com.whatsapp";
    public static final String WHATSAPP_CLASSNAME = "com.whatsapp.ContactPicker";
    public static final String TWITTER_PACKAGE = "com.twitter.android";
    public static final String TWITTER_CLASSNAME = "com.twitter.android.PostActivity";
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$", 2);

    public static String decimalFunction(Double d, char separator, int numberDecimals) {
        String decimals = ".";
        for (int i = 0; i < numberDecimals; ++i) {
            decimals = decimals + "0";
        }
        String format = "###" + decimals;
        try {
            String temp = Double.toString(d);
            DecimalFormat decimalFormat = new DecimalFormat(format);
            String retorn = temp.startsWith("0") ? "0" + decimalFormat.format(Double.parseDouble(temp)).replace(",", separator + "") : decimalFormat.format(Double.parseDouble(temp)).replace(",", separator + "");
            if (retorn.contains(decimals)) {
                retorn = retorn.replace(decimals, "");
            }
            if (separator != '.' && retorn.contains(".")) {
                retorn.replace('.', separator);
            }
            return retorn;
        }
        catch (Exception eio) {
            LogBZ.getInstance();
            LogBZ.printStackTrace(eio);
            return "0";
        }
    }

    public static String decimalFunction(String d, char separator, int numberDecimals) {
        return BZUtils.decimalFunction(Double.parseDouble(d), separator, numberDecimals);
    }

    public static String decimalFunction(Double d, char separator) {
        return BZUtils.decimalFunction(d, separator, 2);
    }

    public static String decimalFunction(String d, char separator) {
        return BZUtils.decimalFunction(d, separator, 2);
    }

    public static String decimalFunction(Double d, int numberDecimals) {
        return BZUtils.decimalFunction(d, '.', numberDecimals);
    }

    public static String decimalFunction(String d, int numberDecimals) {
        return BZUtils.decimalFunction(d, '.', numberDecimals);
    }

    public static String decimalFunction(Double d) {
        return BZUtils.decimalFunction(d, '.', 2);
    }

    public static String decimalFunction(String d) {
        return BZUtils.decimalFunction(d, '.', 2);
    }

    public static Date stringToDate(String date, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(date);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date getDateFromTimeStamp(long timeStamp) {
        return new Date(timeStamp * 1000L);
    }

    public static String getDateFromTimeStamp(long timeStamp, String format) {
        return BZUtils.dateToString(BZUtils.getDateFromTimeStamp(timeStamp), format);
    }

    public static BZPeriod getTimeBetweenDates(Date d1, Date d2) {
        try {
            if (d1 != null && d2 != null) {
                long milis = d1.getTime() - d2.getTime();
                if (milis < 0L) {
                    milis *= -1L;
                }
                Double min = milis / 1000L / 60L;
                Double hour = min / 60.0;
                Double day = hour / 24.0;
                Double month = day / 30.0;
                Double year = month / 12.0;
                min = min - (double)(hour.intValue() * 60);
                hour = hour - (double)(day.intValue() * 24);
                day = day - (double)(month.intValue() * 30);
                month = month - (double)(year.intValue() * 12);
                BZPeriod period = new BZPeriod();
                period.setYears(year.intValue());
                period.setMonths(month.intValue());
                period.setDays(day.intValue());
                period.setHours(hour.intValue());
                period.setMinutes(min.intValue());
                return period;
            }
        }
        catch (Exception eio) {
            LogBZ.getInstance();
            LogBZ.printStackTrace(eio);
        }
        return null;
    }

    public static void showSimpleMessage(final Activity ctx, final String text, final String buttonText, final String title, final Integer icon, final boolean closeActivity, final DialogInterface.OnClickListener clickListener) {
        ctx.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dialog = new AlertDialog.Builder((Context)ctx);
                dialog.setMessage((CharSequence)text);
                if (title != null) {
                    dialog.setTitle((CharSequence)title);
                }
                if (icon != null) {
                    dialog.setIcon(icon.intValue());
                }
                dialog.setCancelable(false);
                dialog.setPositiveButton((CharSequence)buttonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (clickListener != null) {
                            clickListener.onClick(dialog, which);
                        }
                        dialog.dismiss();
                        if (closeActivity) {
                            ctx.finish();
                        }
                    }
                });
                AlertDialog alert = dialog.create();
                alert.show();
            }
        });
    }

    public static void showSimpleMessageWithTwoButtons(final Activity ctx, final String text, final String texte1, final String texte2, final DialogInterface.OnClickListener escolta1, final DialogInterface.OnClickListener escolta2) {
        ctx.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dialog = new AlertDialog.Builder((Context)ctx);
                dialog.setMessage((CharSequence)text);
                dialog.setCancelable(false);
                dialog.setPositiveButton((CharSequence)texte1, escolta1);
                dialog.setNegativeButton((CharSequence)texte2, escolta2);
                AlertDialog alert = dialog.create();
                alert.show();
            }
        });
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText, String title, boolean closeActivity) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, title, null, closeActivity, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText, String title) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, title, null, false, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText, Integer icon, boolean closeActivity) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, null, icon, closeActivity, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText, Integer icon) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, null, icon, false, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText, boolean closeActivity) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, null, null, closeActivity, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, String buttonText) {
        BZUtils.showSimpleMessage(ctx, text, buttonText, null, null, false, null);
    }

    public static void showSimpleMessage(Activity ctx, String text, boolean closeActivity) {
        BZUtils.showSimpleMessage(ctx, text, "OK", closeActivity);
    }

    public static void showSimpleMessage(Activity ctx, String text, DialogInterface.OnClickListener onClickListener) {
        BZUtils.showSimpleMessage(ctx, text, "OK", null, null, false, onClickListener);
    }

    public static void showSimpleMessage(Activity ctx, String text) {
        BZUtils.showSimpleMessage(ctx, text, "OK", false);
    }

    public static void showRetryError(Context ctx, String text, DialogInterface.OnClickListener clickListener, String cancelButton, String retryButton, String title, Integer icon) {
        AlertDialog.Builder dialog = new AlertDialog.Builder(ctx);
        dialog.setMessage((CharSequence)text);
        if (title != null) {
            dialog.setTitle((CharSequence)title);
        }
        if (icon != null) {
            dialog.setIcon(icon.intValue());
        }
        dialog.setCancelable(false);
        dialog.setNegativeButton((CharSequence)cancelButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        dialog.setPositiveButton((CharSequence)retryButton, clickListener);
        AlertDialog alert = dialog.create();
        alert.show();
    }

    public static void showRetryError(Context ctx, String text, DialogInterface.OnClickListener clickListener, String cancelButton, String retryButton, String title) {
        BZUtils.showRetryError(ctx, text, clickListener, cancelButton, retryButton, title, null);
    }

    public static void showRetryError(Context ctx, String text, DialogInterface.OnClickListener clickListener, String cancelButton, String retryButton) {
        BZUtils.showRetryError(ctx, text, clickListener, cancelButton, retryButton, null, null);
    }

    public static void showRetryError(Context ctx, String text, DialogInterface.OnClickListener clickListener) {
        BZUtils.showRetryError(ctx, text, clickListener, "OK", "Reintentar");
    }

    public static void showCustomAlert(Context ctx, View v, String message, int textViewId, Button button1, View.OnClickListener listener1) {
        BZUtils.showCustomAlert(ctx, v, message, textViewId, button1, listener1, null, null);
    }

    public static void showCustomAlert(Context ctx, View v, String message, int textViewId, Button button1, View.OnClickListener listener1, Button button2, View.OnClickListener listener2) {
        BZUtils.showCustomAlert(ctx, v, message, textViewId, button1, listener1, button2, listener2, null, null);
    }

    public static void showCustomAlert(Context ctx, View v, String message, int textViewId, Button button1, final View.OnClickListener listener1, Button button2, final View.OnClickListener listener2, Button button3, final View.OnClickListener listener3) {
        final Dialog dialog = new Dialog(ctx);
        dialog.requestWindowFeature(1);
        if (message != null && textViewId != 0) {
            TextView msg = (TextView)v.findViewById(textViewId);
            msg.setText((CharSequence)message);
        }
        dialog.setContentView(v);
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(false);
        button1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener1 != null) {
                    listener1.onClick(v);
                }
                dialog.dismiss();
            }
        });
        if (button2 != null) {
            button2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener2 != null) {
                        listener2.onClick(v);
                    }
                    dialog.dismiss();
                }
            });
        }
        if (button3 != null) {
            button3.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener3 != null) {
                        listener3.onClick(v);
                    }
                    dialog.dismiss();
                }
            });
        }
        dialog.show();
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String destine, String[] destines, Uri attachedFile) {
        Intent i = new Intent("android.intent.action.SEND");
        i.setType("message/rfc822");
        i.setPackage("com.google.android.gm");
        if (destine != null) {
            String[] st = new String[]{destine};
            i.putExtra("android.intent.extra.EMAIL", st);
        }
        if (destines != null) {
            i.putExtra("android.intent.extra.BCC", destines);
        }
        i.putExtra("android.intent.extra.SUBJECT", subject);
        i.putExtra("android.intent.extra.TEXT", mailBody);
        if (attachedFile != null) {
            i.putExtra("android.intent.extra.STREAM", (Parcelable)attachedFile);
        }
        ctx.startActivity(i);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String destine, String[] destines) {
        BZUtils.shareViaMail(ctx, mailBody, subject, destine, destines, null);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String destine, Uri attachedFile) {
        BZUtils.shareViaMail(ctx, mailBody, subject, destine, null, attachedFile);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String[] destines, Uri attachedFile) {
        BZUtils.shareViaMail(ctx, mailBody, subject, null, destines, attachedFile);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String destine) {
        BZUtils.shareViaMail(ctx, mailBody, subject, destine, null, null);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, String[] destines) {
        BZUtils.shareViaMail(ctx, mailBody, subject, null, destines, null);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject, Uri attachedFile) {
        BZUtils.shareViaMail(ctx, mailBody, subject, null, null, attachedFile);
    }

    public static void shareViaMail(Context ctx, String mailBody, String subject) {
        BZUtils.shareViaMail(ctx, mailBody, subject, null, null, null);
    }

    public static void shareViaApp(Context ctx, String appPackage, String appClassName, String shareBody) throws ShareAppNotAvailable {
        if (BZUtils.isAppInstalled(ctx, appPackage)) {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.setType("text/html");
            intent.putExtra("android.intent.extra.TEXT", shareBody);
            intent.addCategory("android.intent.category.LAUNCHER");
            intent.setFlags(0x10200000);
            intent.setClassName(appPackage, appClassName);
            try {
                ctx.startActivity(intent);
            }
            catch (Exception e) {
                throw new ShareAppNotAvailable(appPackage + " not available");
            }
        } else {
            throw new ShareAppNotAvailable(appPackage + " not installed");
        }
    }

    public static boolean isAppInstalled(Context ctx, String appPackage) {
        Intent shareIntent = new Intent("android.intent.action.SEND");
        shareIntent.setType("text/plain");
        PackageManager pm = ctx.getPackageManager();
        List activityList = pm.queryIntentActivities(shareIntent, 0);
        for (ResolveInfo app : activityList) {
            ActivityInfo ai = app.activityInfo;
            String pkg = ai.packageName;
            if (!pkg.contains(appPackage)) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static boolean DNIvalidation(String nif) {
        Pattern nifPattern;
        Matcher m;
        LogBZ.getInstance();
        LogBZ.v("Validando dni - " + nif);
        if (nif == null) {
            return false;
        }
        nif = nif.replace(" ", "");
        if ((nif = nif.replace("-", "")).toUpperCase().startsWith("X") || nif.toUpperCase().startsWith("Y") || nif.toUpperCase().startsWith("Z")) {
            return false;
        }
        nif = nif.toUpperCase();
        int temp = 0;
        if (nif.toUpperCase().startsWith("X")) {
            temp = 0;
        }
        if (nif.toUpperCase().startsWith("Y")) {
            temp = 1;
        }
        if (nif.toUpperCase().startsWith("Z")) {
            temp = 2;
        }
        if (nif.toUpperCase().startsWith("X") || nif.toUpperCase().startsWith("Y") || nif.toUpperCase().startsWith("Z")) {
            nif = nif.substring(1);
        }
        if ((m = (nifPattern = Pattern.compile("(\\d{1,8})([TRWAGMYFPDXBNJZSQVHLCKE])")).matcher(nif)).matches()) {
            String reference;
            String letra = m.group(2);
            String letras = "TRWAGMYFPDXBNJZSQVHLCKE";
            int dni = Integer.parseInt(Integer.toString(temp) + m.group(1));
            return (reference = letras.substring(dni %= 23, dni + 1)).equalsIgnoreCase(letra);
        }
        return false;
    }

    public static boolean NIEvalidation(String nie) {
        return BZUtils.DNIvalidation(nie);
    }

    public static void configRateMyApp(Context ctx, int days, int uses, boolean reminder, String message, String rateNow, String rateLater) {
        AppRate.displayAsk2Rate(ctx, days, uses, reminder, message, rateNow, rateLater);
    }

    public static void configRateMyAppWithCustomTitle(Context ctx, int days, int uses, boolean reminder, String message, String rateNow, String rateLater, String title) {
        AppRate.displayAsk2RateWithCustomTitle(ctx, days, uses, reminder, message, rateNow, rateLater, title);
    }

    public static void increasesAppUsedToRate(Context ctx) {
        AppRate.increaseAppUsed(ctx);
    }

    public static void myGeoLocation(Context context, LocationListener listener) throws BZLocationException {
        LocationManager manager = (LocationManager)context.getSystemService("location");
        if (!manager.isProviderEnabled("gps") && !manager.isProviderEnabled("network")) {
            throw new BZLocationException("Location provider not enabled");
        }
        if (manager.getLastKnownLocation("network") != null) {
            listener.onLocationChanged(manager.getLastKnownLocation("network"));
        } else if (manager.getLastKnownLocation("gps") != null) {
            listener.onLocationChanged(manager.getLastKnownLocation("gps"));
        }
        Localizator localizator = new Localizator(context);
        localizator.localizate(listener);
    }

    public static double calculateLocationsDistance(Context ctx, Location from, Location to, String unit) {
        return Localizator.calculateDistance(from, to, unit);
    }

    public static double calculateLocationsDistance(Context ctx, double fromLat, double fromLong, double toLat, double toLong, String unit) {
        Location from = new Location("");
        from.setLongitude(fromLong);
        from.setLatitude(fromLat);
        Location to = new Location("");
        to.setLongitude(toLong);
        to.setLatitude(toLat);
        return BZUtils.calculateLocationsDistance(ctx, from, to, unit);
    }

    public static double calculateLocationsDistance(Context ctx, Location from, Location to) {
        return BZUtils.calculateLocationsDistance(ctx, from, to, "K");
    }

    public static double calculateLocationsDistance(Context ctx, double fromLat, double fromLong, double toLat, double toLong) {
        return BZUtils.calculateLocationsDistance(ctx, fromLat, fromLong, toLat, toLong, "K");
    }

    public static String generateQR(String code, int size) {
        return "http://api.qrserver.com/v1/create-qr-code/?size=" + size + "x" + size + "&data=" + code;
    }

    public static String generateQR(String code) {
        return BZUtils.generateQR(code, 100);
    }

    public static String capitalizeFirstLetter(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    public static void getContactsFromPhoneBook(Activity activity, ContactsListener listener) {
        PhoneBookMethods.getPhonebookContacts(activity, listener);
    }

    @SuppressLint(value={"NewApi"})
    public static String formalizeString(String key, Locale locale) {
        key = Normalizer.normalize(key, Normalizer.Form.NFD);
        return key.replaceAll("[^\\p{ASCII}]", "");
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenWidht(Activity ctx) {
        Display display = ctx.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT < 13) {
            return display.getWidth();
        }
        Point p = new Point();
        display.getSize(p);
        return p.x;
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenHeight(Activity ctx) {
        Display display = ctx.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT < 13) {
            return display.getHeight();
        }
        Point p = new Point();
        display.getSize(p);
        return p.y;
    }

    public static boolean checkEmail(String email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static void showKeyboard(Context ctx, EditText editText) {
        InputMethodManager mgr = (InputMethodManager)ctx.getSystemService("input_method");
        mgr.toggleSoftInput(2, 1);
        editText.requestFocus();
    }

    public static void hideKeyboard(Activity ctx) {
        InputMethodManager mgr = (InputMethodManager)ctx.getSystemService("input_method");
        mgr.hideSoftInputFromWindow(ctx.getWindow().getDecorView().getWindowToken(), 0);
    }

    public static String md5(String string) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(string.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String h = Integer.toHexString(0xFF & messageDigest[i]);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LogBZ.printStackTrace(e);
            return "";
        }
    }

    public static void printSignature(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                LogBZ.d("KeyHash: " + Base64.encodeToString((byte[])md.digest(), (int)0));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            LogBZ.printStackTrace((Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException e) {
            LogBZ.printStackTrace(e);
        }
    }
}

