/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils.model;

public class CreditCardValidator {
    public static final byte VISA = 0;
    public static final byte MASTERCARD = 1;
    public static final byte AMEX = 2;
    public static final byte DINERS_CLUB = 3;
    public static final byte CARTE_BLANCHE = 4;
    public static final byte DISCOVER = 5;
    public static final byte ENROUTE = 6;
    public static final byte JCB = 7;

    public static boolean validate(String credCardNumber, byte type) {
        String creditCard = credCardNumber.trim();
        boolean applyAlgo = false;
        switch (type) {
            case 0: {
                if (creditCard.length() < 13 || creditCard.length() > 16 || !creditCard.startsWith("4")) break;
                applyAlgo = true;
                break;
            }
            case 1: {
                int prefix;
                if (creditCard.length() != 16 || (prefix = Integer.parseInt(creditCard.substring(0, 2))) < 51 || prefix > 55) break;
                applyAlgo = true;
                break;
            }
            case 2: {
                if (creditCard.length() != 15 || !creditCard.startsWith("34") && !creditCard.startsWith("37")) break;
                applyAlgo = true;
                break;
            }
            case 3: 
            case 4: {
                int prefix;
                if (creditCard.length() != 14 || ((prefix = Integer.parseInt(creditCard.substring(0, 3))) < 300 || prefix > 305) && !creditCard.startsWith("36") && !creditCard.startsWith("38")) break;
                applyAlgo = true;
                break;
            }
            case 5: {
                if (creditCard.length() != 16 || !creditCard.startsWith("6011")) break;
                applyAlgo = true;
                break;
            }
            case 6: {
                if (creditCard.length() != 16 || !creditCard.startsWith("2014") && !creditCard.startsWith("2149")) break;
                applyAlgo = true;
                break;
            }
            case 7: {
                if ((creditCard.length() != 16 || !creditCard.startsWith("3")) && (creditCard.length() != 15 || !creditCard.startsWith("2131") && !creditCard.startsWith("1800"))) break;
                applyAlgo = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (applyAlgo) {
            return CreditCardValidator.validate(creditCard);
        }
        return false;
    }

    public static boolean validate(String creditCard) {
        int sum = 0;
        int length = creditCard.length();
        for (int i = 0; i < creditCard.length(); ++i) {
            if (0 == i % 2) {
                sum += creditCard.charAt(length - i - 1) - 48;
                continue;
            }
            sum += CreditCardValidator.sumDigits((creditCard.charAt(length - i - 1) - 48) * 2);
        }
        return 0 == sum % 10;
    }

    private static int sumDigits(int i) {
        return i % 10 + i / 10;
    }
}

