/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils.images;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.bzutils.R;
import com.bzutils.images.RoundedDrawable;

public class RoundedImageView
extends ImageView {
    public static final String TAG = "RoundedImageView";
    public static final float DEFAULT_RADIUS = 0.0f;
    public static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final ImageView.ScaleType[] SCALE_TYPES = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private float cornerRadius = 0.0f;
    private float borderWidth = 0.0f;
    private ColorStateList borderColor = ColorStateList.valueOf((int)-16777216);
    private boolean isOval = false;
    private boolean mutateBackground = false;
    private int mResource;
    private Drawable mDrawable;
    private Drawable mBackgroundDrawable;
    private ImageView.ScaleType mScaleType;

    public RoundedImageView(Context context) {
        super(context);
        int index = -1;
        if (index >= 0) {
            this.setScaleType(SCALE_TYPES[index]);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.cornerRadius = -1.0f;
        this.borderWidth = -1.0f;
        if (this.cornerRadius < 0.0f) {
            this.cornerRadius = 0.0f;
        }
        if (this.borderWidth < 0.0f) {
            this.borderWidth = 0.0f;
        }
        this.borderColor = null;
        if (this.borderColor == null) {
            this.borderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.mutateBackground = true;
        this.isOval = true;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(true);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RoundedImageView, defStyle, 0);
        int index = a.getInt(0, -1);
        if (index >= 0) {
            this.setScaleType(SCALE_TYPES[index]);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.cornerRadius = a.getDimensionPixelSize(1, -1);
        this.borderWidth = a.getDimensionPixelSize(2, -1);
        if (this.cornerRadius < 0.0f) {
            this.cornerRadius = 0.0f;
        }
        if (this.borderWidth < 0.0f) {
            this.borderWidth = 0.0f;
        }
        this.borderColor = a.getColorStateList(3);
        if (this.borderColor == null) {
            this.borderColor = ColorStateList.valueOf((int)-16777216);
        }
        this.mutateBackground = true;
        this.isOval = true;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(true);
        a.recycle();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        assert (scaleType != null);
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            switch (scaleType) {
                case CENTER: 
                case CENTER_CROP: 
                case CENTER_INSIDE: 
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: 
                case FIT_XY: {
                    super.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                default: {
                    super.setScaleType(scaleType);
                }
            }
            this.updateDrawableAttrs();
            this.updateBackgroundDrawableAttrs(false);
            this.invalidate();
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromDrawable(drawable2);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = RoundedDrawable.fromBitmap(bm);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageResource(int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            this.updateDrawableAttrs();
            super.setImageDrawable(this.mDrawable);
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable resolveResource() {
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return null;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = rsrc.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Unable to find resource: " + this.mResource), (Throwable)e);
                this.mResource = 0;
            }
        }
        return RoundedDrawable.fromDrawable(d);
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    private void updateDrawableAttrs() {
        this.updateAttrs(this.mDrawable);
    }

    private void updateBackgroundDrawableAttrs(boolean convert) {
        if (this.mutateBackground) {
            if (convert) {
                this.mBackgroundDrawable = RoundedDrawable.fromDrawable(this.mBackgroundDrawable);
            }
            this.updateAttrs(this.mBackgroundDrawable);
        }
    }

    private void updateAttrs(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        if (drawable2 instanceof RoundedDrawable) {
            ((RoundedDrawable)drawable2).setScaleType(this.mScaleType).setCornerRadius(this.cornerRadius).setBorderWidth(this.borderWidth).setBorderColor(this.borderColor).setOval(this.isOval);
        } else if (drawable2 instanceof LayerDrawable) {
            LayerDrawable ld = (LayerDrawable)drawable2;
            int layers = ld.getNumberOfLayers();
            for (int i = 0; i < layers; ++i) {
                this.updateAttrs(ld.getDrawable(i));
            }
        }
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        this.mBackgroundDrawable = background;
        this.updateBackgroundDrawableAttrs(true);
        super.setBackgroundDrawable(this.mBackgroundDrawable);
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public void setCornerRadius(int resId) {
        this.setCornerRadius(this.getResources().getDimension(resId));
    }

    public void setCornerRadius(float radius) {
        if (this.cornerRadius == radius) {
            return;
        }
        this.cornerRadius = radius;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int resId) {
        this.setBorderWidth(this.getResources().getDimension(resId));
    }

    public void setBorderWidth(float width) {
        if (this.borderWidth == width) {
            return;
        }
        this.borderWidth = width;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public int getBorderColor() {
        return this.borderColor.getDefaultColor();
    }

    public void setBorderColor(int color) {
        this.setBorderColor(ColorStateList.valueOf((int)color));
    }

    public ColorStateList getBorderColors() {
        return this.borderColor;
    }

    public void setBorderColor(ColorStateList colors) {
        if (this.borderColor.equals(colors)) {
            return;
        }
        this.borderColor = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        if (this.borderWidth > 0.0f) {
            this.invalidate();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setOval(boolean oval) {
        this.isOval = oval;
        this.updateDrawableAttrs();
        this.updateBackgroundDrawableAttrs(false);
        this.invalidate();
    }

    public boolean isMutateBackground() {
        return this.mutateBackground;
    }

    public void setMutateBackground(boolean mutate) {
        if (this.mutateBackground == mutate) {
            return;
        }
        this.mutateBackground = mutate;
        this.updateBackgroundDrawableAttrs(true);
        this.invalidate();
    }
}

