/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.provider.ContactsContract;
import com.bzutils.LogBZ;
import com.bzutils.listener.ContactsListener;
import com.bzutils.model.Contact;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class PhoneBookMethods {
    private static ArrayList<String> correos;
    private static ContactsListener contactsListener;

    PhoneBookMethods() {
    }

    public static void getPhonebookContacts(Activity act, ContactsListener listener) {
        contactsListener = listener;
        new getContacts().execute(new Activity[]{act});
    }

    private static ArrayList<Contact> readContacts(Activity activity) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        Integer x = 0;
        Cursor phones = activity.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, null);
        while (phones.moveToNext()) {
            Object phone;
            Contact contacto = new Contact();
            try {
                String name = phones.getString(phones.getColumnIndex("display_name"));
                phone = phones.getString(phones.getColumnIndex("data1"));
                contacto.setName(name);
                contacto.setPhone((String)phone);
                contacto.setId(x.toString());
                contacto.setEmails(PhoneBookMethods.getEmail(activity, name));
                BitmapDrawable foto = new BitmapDrawable(PhoneBookMethods.loadContactPhoto(PhoneBookMethods.getId(activity, contacto.getName()), (Context)activity));
                foto = PhoneBookMethods.resizeDrawable((Drawable)foto);
                contacto.setFoto((Drawable)foto);
                contacts.add(contacto);
            }
            catch (Exception eio) {
                LogBZ.getInstance();
                LogBZ.printStackTrace(eio);
            }
            Integer eio = x;
            x = x + 1;
            phone = x;
        }
        phones.close();
        Collections.sort(contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact lhs, Contact rhs) {
                return lhs.getName().compareToIgnoreCase(rhs.getName());
            }
        });
        ArrayList<Contact> contactos = new ArrayList<Contact>();
        ArrayList<Contact> temp = contacts;
        for (int i = 0; i < contacts.size(); ++i) {
            for (int j = 0; j < temp.size(); ++j) {
                if (((Contact)temp.get(j)).getEmails() == null || !((Contact)temp.get(j)).getName().equals(((Contact)contacts.get(i)).getName())) continue;
                for (int k = 0; k < ((Contact)temp.get(j)).getEmails().size(); ++k) {
                    if (((Contact)contacts.get(i)).getEmails().contains(((Contact)temp.get(j)).getEmails().get(k))) continue;
                    ((Contact)contacts.get(i)).getEmails().add(((Contact)temp.get(j)).getEmails().get(k));
                }
                String name = ((Contact)temp.get(j)).getName();
                name = name.toUpperCase();
                break;
            }
            if (contactos.contains(contacts.get(i))) continue;
            contactos.add((Contact)contacts.get(i));
        }
        return contactos;
    }

    private static ArrayList<String> getEmail(Activity act, String NAME) {
        ContentResolver cr = act.getContentResolver();
        String email = "";
        Cursor cursor = cr.query(ContactsContract.Contacts.CONTENT_URI, null, "DISPLAY_NAME = '" + NAME + "'", null, null);
        act.startManagingCursor(cursor);
        if (cursor.moveToFirst()) {
            String contactId = cursor.getString(cursor.getColumnIndex("_id"));
            Cursor emails = cr.query(ContactsContract.CommonDataKinds.Email.CONTENT_URI, null, "contact_id = " + contactId, null, null);
            act.startManagingCursor(emails);
            String name = NAME;
            String anterior = "";
            while (emails.moveToNext()) {
                email = emails.getString(emails.getColumnIndex("data1"));
                if (!anterior.equalsIgnoreCase(emails.getString(emails.getColumnIndex("data1")))) {
                    correos.add(email);
                }
                anterior = email;
            }
            emails.close();
        }
        cursor.close();
        return correos;
    }

    public static Bitmap loadContactPhoto(long id2, Context c) {
        Uri uri = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)id2);
        InputStream input = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)c.getContentResolver(), (Uri)uri);
        if (input == null) {
            return null;
        }
        return BitmapFactory.decodeStream((InputStream)input);
    }

    private static long getId(Activity act, String NAME) {
        Cursor cursor = act.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, null, "DISPLAY_NAME = '" + NAME + "'", null, null);
        if (cursor.moveToFirst()) {
            String contactId = cursor.getString(cursor.getColumnIndex("_id"));
            return Long.parseLong(contactId);
        }
        cursor.close();
        return 0L;
    }

    private static Drawable resizeDrawable(Drawable d) {
        Bitmap bitmapOrg;
        if (d != null && (bitmapOrg = ((BitmapDrawable)d).getBitmap()) != null) {
            int width = bitmapOrg.getWidth();
            int height = bitmapOrg.getHeight();
            int newWidth = 50;
            int newHeight = 50;
            float scaleWidth = (float)newWidth / (float)width;
            float scaleHeight = (float)newHeight / (float)height;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            d = new BitmapDrawable(resizedBitmap);
        }
        return d;
    }

    private static class getContacts
    extends AsyncTask<Activity, Void, ArrayList<Contact>> {
        private getContacts() {
        }

        protected ArrayList<Contact> doInBackground(Activity ... arg0) {
            return PhoneBookMethods.readContacts(arg0[0]);
        }

        protected void onPostExecute(ArrayList<Contact> res) {
            if (res == null) {
                if (contactsListener != null) {
                    contactsListener.onContactsFailed("Error getting phonebook contacts");
                }
            } else if (contactsListener != null) {
                contactsListener.onContactsReceived(res);
            }
        }
    }
}

