/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import com.testflightapp.lib.TestFlight;
import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.networking.HttpRequest;
import com.testflightapp.lib.core.networking.IEndpoint;
import com.testflightapp.lib.core.newapi.ConnectionStateWatcher;
import com.testflightapp.lib.core.newapi.IJobScheduler;
import com.testflightapp.lib.core.newapi.Job;
import com.testflightapp.lib.core.newapi.SchedulerAwareJob;
import com.testflightapp.lib.endpoints.TokensEndpoint;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;

public class RegisterApplicationJob
extends SchedulerAwareJob
implements ConnectionStateWatcher.IConnectivityListener {
    private static final String TAG = RegisterApplicationJob.class.getSimpleName();
    private static final int HTTP_TIMEOUT_MS = 10000;
    private static final int WAIT_TIME_ON_FAILURE = 10000;
    private final IRegisterAppJobListener mListener;
    private final IEndpoint mTokensEndpoint;
    private volatile boolean mScheduled;

    public RegisterApplicationJob(IRegisterAppJobListener iRegisterAppJobListener, String string) {
        super("Register application Job");
        this.mListener = iRegisterAppJobListener;
        this.mTokensEndpoint = new TokensEndpoint(string);
    }

    @Override
    protected void runJob() {
        this.tokensRequest();
    }

    private void tokensRequest() {
        try {
            HttpRequest httpRequest = this.mTokensEndpoint.generateRequest(TestFlight.getDeviceInfo(), TestFlight.getBundleInfo(), null);
            HttpResponse httpResponse = httpRequest.executeRequest(10000);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                Map<String, Object> map = this.mTokensEndpoint.parseResponse(httpResponse.getEntity());
                this.mListener.onTokensRequestFinished(this, map);
            } else {
                this.tokensRequestFailed();
            }
            this.setRecurrentInterval(0L);
        }
        catch (Exception exception) {
            Logger.e(TAG, "Error registering application. Attempt rescheduled in 10000 ms");
            this.setRecurrentInterval(10000L);
        }
    }

    private void tokensRequestFailed() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put("valid", false);
        this.mListener.onTokensRequestFinished(this, hashMap);
    }

    @Override
    protected int getJobId() {
        return 2;
    }

    @Override
    public void onConnected() {
        IJobScheduler iJobScheduler = this.getScheduler();
        if (iJobScheduler != null && !this.mScheduled) {
            this.mScheduled = true;
            iJobScheduler.addJob(this);
        }
    }

    @Override
    public void onDisconnected() {
        IJobScheduler iJobScheduler = this.getScheduler();
        if (iJobScheduler != null) {
            this.mScheduled = false;
            iJobScheduler.removeJob(this);
        }
    }

    public static interface IRegisterAppJobListener {
        public void onTokensRequestFinished(Job var1, Map<String, Object> var2);
    }
}

