/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import com.testflightapp.lib.core.newapi.Job;

public class AppStateWatcher
extends Job {
    private static int sBackgroundInterval = 2000;
    private static int sForegroundInterval = 1000;
    private final IStateChangeListener mListener;
    private final Context mContext;
    private boolean mIsInBackground;

    public static void setCheckIntervals(int n, int n2) {
        sBackgroundInterval = n;
        sForegroundInterval = n2;
    }

    public AppStateWatcher(Context context, IStateChangeListener iStateChangeListener) {
        super("Application Background Watcher", sForegroundInterval);
        this.mContext = context;
        this.mListener = iStateChangeListener;
    }

    @Override
    protected void runJob() {
        boolean bl = AppStateWatcher.isAppInBackground(this.mContext);
        if (bl != this.mIsInBackground && this.mListener != null) {
            this.mListener.appStateChanged(bl);
        }
        this.mIsInBackground = bl;
        this.setRecurrentInterval(bl ? (long)sBackgroundInterval : (long)sForegroundInterval);
    }

    public static boolean isAppInBackground(Context context) {
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses()) {
            if (runningAppProcessInfo.pid != Process.myPid() || runningAppProcessInfo.uid != Process.myUid()) continue;
            return runningAppProcessInfo.importance == 400;
        }
        return true;
    }

    @Override
    protected int getJobId() {
        return 0;
    }

    public static interface IStateChangeListener {
        public void appStateChanged(boolean var1);
    }
}

