/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.networking;

import com.testflightapp.lib.TestFlight;
import com.testflightapp.lib.core.networking.NetworkEnvironment;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpRequest {
    private final String mURL;
    private final boolean mIsPost;
    private final Map<String, String> mHeaders;
    private static DefaultHttpClient sDefaultHttpClient;
    private final HttpEntity mPostData;

    public String getUrl() {
        if (TestFlight.ENV == NetworkEnvironment.PRODUCTION) {
            return "https://" + this.mURL;
        }
        return "http://" + this.mURL;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public static HttpRequest createGet(String string, Map<String, String> map) {
        if (string == null) {
            throw new NullPointerException("host parameter can not be null");
        }
        return new HttpRequest(string, map, false, null);
    }

    public static HttpRequest createPost(String string, Map<String, String> map, HttpEntity httpEntity) {
        if (string == null) {
            throw new NullPointerException("host parameter can not be null");
        }
        return new HttpRequest(string, map, true, httpEntity);
    }

    private HttpRequest(String string, Map<String, String> map, boolean bl, HttpEntity httpEntity) {
        this.mURL = HttpRequest.removeProtocol(string.trim());
        this.mHeaders = map;
        this.mIsPost = bl;
        this.mPostData = httpEntity;
    }

    public HttpResponse executeRequest() throws IOException {
        return this.executeRequest(-1);
    }

    public HttpResponse executeRequest(int n) throws IOException {
        HttpPost httpPost;
        if (this.mIsPost) {
            httpPost = new HttpPost(this.getUrl());
            if (this.mPostData != null) {
                httpPost.setEntity(this.mPostData);
            }
        } else {
            httpPost = new HttpGet(this.getUrl());
        }
        if (httpPost.getURI().getHost() == null) {
            throw new IOException("Could not resolve " + this.mURL);
        }
        this.setHeadersInRequest((HttpRequestBase)httpPost);
        return HttpRequest.getClient(n).execute((HttpUriRequest)httpPost);
    }

    private void setHeadersInRequest(HttpRequestBase httpRequestBase) {
        if (this.mHeaders != null) {
            Object[] objectArray;
            for (Object object : objectArray = this.mHeaders.keySet().toArray()) {
                httpRequestBase.addHeader((String)object, this.mHeaders.get(object));
            }
        }
    }

    private static synchronized HttpClient getClient(int n) {
        if (sDefaultHttpClient != null) {
            return sDefaultHttpClient;
        }
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        if (n != -1) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)n);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)n);
        }
        sDefaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
        return sDefaultHttpClient;
    }

    private static String removeProtocol(String string) {
        if (string.startsWith("http://")) {
            return string.substring("http://".length());
        }
        if (string.startsWith("https://")) {
            return string.substring("https://".length());
        }
        return string;
    }
}

