/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.collector;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.collector.Compatibility;
import java.lang.reflect.Method;

final class DeviceFeaturesCollector {
    DeviceFeaturesCollector() {
    }

    public static String getFeatures(Context ctx) {
        if (Compatibility.getAPILevel() < 5) {
            return "Data available only with API Level >= 5";
        }
        StringBuilder result = new StringBuilder();
        try {
            Object[] features;
            PackageManager pm = ctx.getPackageManager();
            Method getSystemAvailableFeatures = PackageManager.class.getMethod("getSystemAvailableFeatures", null);
            for (Object feature : features = (Object[])getSystemAvailableFeatures.invoke((Object)pm, new Object[0])) {
                String featureName = (String)feature.getClass().getField("name").get(feature);
                if (featureName != null) {
                    result.append(featureName);
                } else {
                    Method getGlEsVersion = feature.getClass().getMethod("getGlEsVersion", null);
                    String glEsVersion = (String)getGlEsVersion.invoke(feature, new Object[0]);
                    result.append("glEsVersion = ");
                    result.append(glEsVersion);
                }
                result.append("\n");
            }
        }
        catch (Throwable e) {
            Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve DeviceFeatures for " + ctx.getPackageName()), (Throwable)e);
            result.append("Could not retrieve data: ");
            result.append(e.getMessage());
        }
        return result.toString();
    }
}

